// import "react-native-gesture-handler";
import { GestureHandlerRootView } from "react-native-gesture-handler";
import React, { useState, useEffect } from "react";
import { LogBox, StatusBar, Platform, View, Text } from "react-native";
import NetInfo from "@react-native-community/netinfo";
import { onAuthStateChanged } from "firebase/auth";
import { auth } from "./config/firebase";
import Navigator from "./src/navigation/Navigator";

import {
  useFonts,
  Inter_300Light,
  Inter_400Regular,
  Inter_500Medium,
  Inter_700Bold,
} from "@expo-google-fonts/inter";
import ConnectionError from "./src/components/ConnectionError";
// import moment from "moment";
import AuthNav from "./src/navigation/AuthNav";
import Test from "./src/screens/Test";

export default function App() {
  const [connected, setConnected] = useState(true);
  const [authenticated, setAuthenticated] = useState(true);
  const [loaded, setLoaded] = useState(false);

  useEffect(() => {
    // StatusBar.setBarStyle(
    //   Platform.OS === "ios" ? "dark-content" : "light-content"
    // );
    // if (Platform.OS === "android") {
    //   StatusBar.setBackgroundColor("#000000");
    // }
    // moment.locale("fr");
    LogBox.ignoreAllLogs();
    checkAuth();
    const unsubscribe = NetInfo.addEventListener((state) => {
      setConnected(state.isConnected);
    });

    return () => unsubscribe();
  }, []);

  const checkAuth = async () => {
    const unsusbcribe = onAuthStateChanged(auth, (user) => {
      if (user) {
        setAuthenticated(true);
      } else {
        setAuthenticated(false);
      }
      setLoaded(true);
    });
    return () => unsusbcribe();
  };

  const [fontsLoaded, error] = useFonts({
    Inter_300Light,
    Inter_400Regular,
    Inter_500Medium,
    Inter_700Bold,
  });

  if (!loaded || !fontsLoaded || error) {
    return null;
  }
  return (
    <GestureHandlerRootView style={{ flex: 1 }}>
      {!connected ? (
        <ConnectionError />
      ) : authenticated ? (
        <Navigator />
      ) : (
        <AuthNav />
      )}
    </GestureHandlerRootView>
  );
}
