import { View } from "react-native";
import Icon from "./Icons";

export default function ListIcons({
  itemIsActive,
  one,
  two,
  three,
  notif,
  onPress1,
  onPress2,
  onPress3,
  onPressNotif,
}) {
  return (
    <View className="flex-row items-center justify-center">
      {one && (
        <Icon
          square
          margin
          w={20}
          bgColor={"#dfe6e9"}
          onPress={() => onPress1()}
          color={"green"}
          icon={"pencil-outline"}
        />
      )}
      {two && (
        <Icon
          square
          margin
          w={20}
          bgColor={"#dfe6e9"}
          onPress={() => onPress2()}
          color={"#3498db"}
          icon={"pencil-outline"}
        />
      )}

{notif && (
        <Icon
          square
          margin
          w={20}
          bgColor={"#dfe6e9"}
          onPress={() => onPressNotif()}
          color={"#3498db"}
          icon={"mail-unread-outline"}
        />
      )}
      {three && (
        <Icon
          square
          margin
          w={20}
          bgColor={"#dfe6e9"}
          onPress={() => onPress3()}
          color={`${itemIsActive ? "red" : "green"}`}
          icon={`${itemIsActive ? "close-outline" : "checkmark-outline"}`}
        />
      )}
    </View>
  );
}
