import {
  View,
  Text,
  Image,
  SafeAreaView,
  TouchableOpacity,
  Alert,
  StatusBar,
  Platform,
} from "react-native";
import React, {
  useCallback,
  useEffect,
  useLayoutEffect,
  useState,
} from "react";
import { collection, doc, getDocs, query, setDoc, where } from "firebase/firestore";
import { auth, db } from "../../config/firebase";
import { Dimensions } from "react-native";
import { LineChart, ProgressChart } from "react-native-chart-kit";
import PageLoader from "../components/Loaders/PageLoader";
import { useSafeAreaInsets } from "react-native-safe-area-context";
import { KeyboardAwareScrollView } from "react-native-keyboard-aware-scroll-view";
import { DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING } from "../styles/constants";
import { COLORS } from "../styles/colors";
import { Ionicons } from "@expo/vector-icons";
import AsyncStorage from "@react-native-async-storage/async-storage";
import { signOut } from "firebase/auth";
import PageTitle from "../components/Titles/PageTitle";
import { useFocusEffect } from "@react-navigation/native";
import * as Device from "expo-device";
import * as Notifications from "expo-notifications";
import Constants from "expo-constants";

import * as Constantss from "expo-constants";

Notifications.setNotificationHandler({
  handleNotification: async () => ({
    shouldShowAlert: true,
    shouldPlaySound: false,
    shouldSetBadge: false,
  }),
});

export default function Home({ navigation }) {
  const buildNumber =
    Platform.OS === "ios"
      ? Constantss.default.expoConfig.ios.buildNumber
      : Constantss.default.expoConfig.android.versionCode;

  const [userRegistrationMonth2023, setUserRegistrationMonth2023] = useState(
    []
  );
  const [userRegistrationMonth2024, setUserRegistrationMonth2024] = useState(
    []
  );
  const [totalUsers2023, setTotalUsers2023] = useState([]);
  const [totalUsers2024, setTotalUsers2024] = useState([]);
  const [totalCounts, setTotalCounts] = useState(null);
  const [isLoading, setIsLoading] = useState(true);
  const screenWidth = Dimensions.get("window").width;
  const insets = useSafeAreaInsets();

  useFocusEffect(
    useCallback(() => {
      Platform.OS === "ios"
        ? StatusBar.setBarStyle("light-content")
        : (StatusBar.setBarStyle("light-content"),
          Platform.OS !== "ios" && StatusBar.setBackgroundColor("#00000"));
      return () => {
        Platform.OS === "ios"
          ? StatusBar.setBarStyle("dark-content")
          : (StatusBar.setBarStyle("light-content"),
            Platform.OS !== "ios" && StatusBar.setBackgroundColor("#00000"));
      };
    }, [])
  );

  useLayoutEffect(() => {
    navigation.setOptions({
      header: () => (
        <View
          className="flex-row items-center justify-between px-4 py-2"
          style={{ paddingTop: insets.top, backgroundColor: COLORS.primary }}
        >
          <View className="flex-row items-center">
           

            <View>
              <Text
                className="ml-2 text-base text-white"
                style={{ fontFamily: "Inter_500Medium" }}
              >
                VAVEL
              </Text>
              <Text
                className="ml-2 mt-1 text-xs text-gray-200 capitalize"
                style={{ fontFamily: "Inter_500Medium" }}
              >
                Admin S4P V{Constantss.default.expoConfig.version} (
                {buildNumber})
              </Text>
            </View>
          </View>
          <TouchableOpacity
            onPress={validateSignOut}
            className="items-center justify-center w-8 h-8 bg-white rounded-full"
          >
            <Ionicons name={`power`} size={24} color={"red"} />
          </TouchableOpacity>
        </View>
      ),
    });
  }, [navigation]);

  useEffect(() => {
    getToken();
    countUserRegistrationsByMonthAndCounts();
  }, []);

  async function registerForPushNotificationsAsync() {
    let token;
    if (Device.isDevice) {
      const { status: existingStatus } =
        await Notifications.getPermissionsAsync();
      let finalStatus = existingStatus;
      if (existingStatus !== "granted") {
        const { status } = await Notifications.requestPermissionsAsync();
        finalStatus = status;
      }
      if (finalStatus !== "granted") {
        alert("Failed to get push token for push notification!");
        return;
      }
      let token = await Notifications.getExpoPushTokenAsync({
        projectId: Constants.expoConfig.extra.eas.projectId,
      });
      return token.data;
    } else {
      // alert("Must use physical device for Push Notifications");
    }

    if (Platform.OS === "android") {
      Notifications.setNotificationChannelAsync("default", {
        name: "default",
        importance: Notifications.AndroidImportance.MAX,
        vibrationPattern: [0, 250, 250, 250],
        lightColor: "#FF231F7C",
      });
    }

    return token;
  }

  async function getToken() {
    registerForPushNotificationsAsync().then((token) =>
      addExpoPushTokenToUser(token)
    );

    registerForPushNotificationsAsync();
  }

  async function addExpoPushTokenToUser(token) {
    await setDoc(
      doc(db, "users", auth.currentUser.uid),
      {
        expoPushToken: token == "" ? "" : token,
      },
      { merge: true }
    );
  }

  const validateSignOut = () => {
    Alert.alert(
      "Se déconnecter",
      "Êtes vous sure de vouloir vous déconnecter?",
      [
        { text: "Déconnexion", onPress: () => logOut() },
        {
          text: "Annuler",
          style: "cancel",
        },
      ],
      {
        cancelable: true,
      }
    );
  };

  const logOut = async () => {
    setIsLoading(true);
    setTimeout(async () => {
      await signOut(auth);
    }, 500);
  };

  // async function countUserRegistrationsByMonth() {
  //   const q = query(collection(db, "users"));
  //   const querySnapshot = await getDocs(q);
  //   const userData = querySnapshot.docs.map((res) => res.data());

  //   const userRegistrationsByMonth = Array.from({ length: 12 }, () => 0);

  //   userData.forEach((user) => {
  //     const userMonth = new Date(user.createdAt).getMonth();
  //     userRegistrationsByMonth[userMonth]++;
  //   });

  //   setUserRegistrationMonth(userRegistrationsByMonth);
  //   setIsLoading(false);
  // }

  // async function countUserRegistrationsByMonth() {
  //   try {
  //     const q = query(collection(db, "users"));
  //     const querySnapshot = await getDocs(q);
  //     const userData = querySnapshot.docs.map((res) => res.data());

  //     const userRegistrations2024ByMonth = Array.from({ length: 12 }, () => 0);
  //     const userRegistrations2023ByMonth = Array.from({ length: 12 }, () => 0);

  //     let totalUsers2024 = 0;
  //     let totalUsers2023 = 0;

  //     userData.forEach((user) => {
  //       const createdAtDate = new Date(user.createdAt);
  //       const userYear = createdAtDate.getFullYear();
  //       const userMonth = createdAtDate.getMonth();

  //       if (userYear === 2024) {
  //         userRegistrations2024ByMonth[userMonth] = Math.ceil(
  //           userRegistrations2024ByMonth[userMonth] + 1
  //         );
  //         totalUsers2024++;
  //       } else if (userYear === 2023) {
  //         userRegistrations2023ByMonth[userMonth] = Math.ceil(
  //           userRegistrations2023ByMonth[userMonth] + 1
  //         );
  //         totalUsers2023++;
  //       }
  //     });

  //     setUserRegistrationMonth2023(userRegistrations2023ByMonth);
  //     setUserRegistrationMonth2024(userRegistrations2024ByMonth);
  //     setTotalUsers2023(totalUsers2023);
  //     setTotalUsers2024(totalUsers2024);

  //     counts();
  //   } catch (error) {
  //     Alert.alert("Une erreur est survenue", `${error}`);
  //   } finally {
  //     setIsLoading(false);
  //   }
  // }

  // async function counts() {
  //   const usersQ = query(collection(db, "users"));
  //   const searchsQ = query(collection(db, "searchs"));
  //   const findedQ = query(
  //     collection(db, "searchs"),
  //     where("finderId", "!=", null),
  //     where("finderId", "!=", "")
  //   );

  //   const paiedQ = query(
  //     collection(db, "searchs"),
  //     where("paymentStatus", "==", "paid")
  //   );

  //   const querySnapshot = await getDocs(usersQ);
  //   const searchQuerySnapshot = await getDocs(searchsQ);
  //   const findedQuerySnapshot = await getDocs(findedQ);
  //   const paiedQuerySnapshot = await getDocs(paiedQ);

  //   setTotalCounts([
  //     querySnapshot.size,
  //     searchQuerySnapshot.size,
  //     findedQuerySnapshot.size,
  //     paiedQuerySnapshot.size,
  //   ]);
  // }

  async function countUserRegistrationsByMonthAndCounts() {
    try {
      const usersQ = query(collection(db, "users"));
      const searchsQ = query(collection(db, "searchs"));
      const findedQ = query(
        collection(db, "searchs"),
        where("finderId", "!=", null)
      );
      const paiedQ = query(
        collection(db, "searchs"),
        where("paymentStatus", "==", "paid")
      );
  
      // Execute all queries concurrently
      const [usersSnapshot, searchSnapshot, findedSnapshot, paiedSnapshot] = await Promise.all([
        getDocs(usersQ),
        getDocs(searchsQ),
        getDocs(findedQ),
        getDocs(paiedQ)
      ]);
  
      const userData = usersSnapshot.docs.map((res) => res.data());
  
      const userRegistrations2024ByMonth = Array.from({ length: 12 }, () => 0);
      const userRegistrations2023ByMonth = Array.from({ length: 12 }, () => 0);
  
      let totalUsers2024 = 0;
      let totalUsers2023 = 0;
  
      userData.forEach((user) => {
        const createdAtDate = new Date(user.createdAt);
        const userYear = createdAtDate.getFullYear();
        const userMonth = createdAtDate.getMonth();
  
        if (userYear === 2024) {
          userRegistrations2024ByMonth[userMonth] += 1;
          totalUsers2024++;
        } else if (userYear === 2023) {
          userRegistrations2023ByMonth[userMonth] += 1;
          totalUsers2023++;
        }
      });
  
      setUserRegistrationMonth2023(userRegistrations2023ByMonth);
      setUserRegistrationMonth2024(userRegistrations2024ByMonth);
      setTotalUsers2023(totalUsers2023);
      setTotalUsers2024(totalUsers2024);
  
      setTotalCounts([
        usersSnapshot.size,
        searchSnapshot.size,
        findedSnapshot.size,
        paiedSnapshot.size
      ]);
  
    } catch (error) {
      Alert.alert("Une erreur est survenue", `${error}`);
    } finally {
      setIsLoading(false);
    }
  }
  

  const chartConfig = {
    backgroundGradientFrom: "blue",
    backgroundGradientFromOpacity: 0.7,
    backgroundGradientTo: "red",
    backgroundGradientToOpacity: 1,
    color: (opacity = 1) => `rgba(255, 255, 255, ${opacity})`,
    strokeWidth: 2,
    barPercentage: 0.5,
    useShadowColorFromDataset: false,
  };

  const data = {
    labels: [
      "Jan",
      "Fev",
      "Mar",
      "Avr",
      "Mai",
      "Jui",
      "Jui",
      "Aoû",
      "Sep",
      "Oct",
      "Nov",
      "Dec",
    ],
    datasets: [
      {
        data: userRegistrationMonth2023,
        color: (opacity = 1) => `rgba(134, 65, 244, ${opacity})`,
        strokeWidth: 2,
      },
    ],
    legend: [`Total 2023 (${totalUsers2023})`],
  };
  const data2024 = {
    labels: [
      "Jan",
      "Fev",
      "Mar",
      "Avr",
      "Mai",
      "Jui",
      "Jui",
      "Aoû",
      "Sep",
      "Oct",
      "Nov",
      "Dec",
    ],
    datasets: [
      {
        data: userRegistrationMonth2024,
        color: (opacity = 1) => `rgba(134, 65, 244, ${opacity})`,
        strokeWidth: 2,
      },
    ],
    legend: [`Total 2024 (${totalUsers2024})`],
  };

  const progressData = {
    labels: ["Utilisateurs vérifiés", "Véhicules retrouvés"],
    data: [1, 0.8],
  };

  const chartConfigg = {
    backgroundGradientFrom: "blue",
    backgroundGradientFromOpacity: 0.7,
    backgroundGradientTo: "skyblue",
    backgroundGradientToOpacity: 1,
    color: (opacity = 1) => `rgba(255, 255, 255, ${opacity})`,
    strokeWidth: 2,
  };

  if (isLoading) {
    return <PageLoader />;
  }

  const List = ({ icon, text, number }) => (
    <View className="w-[50%]">
      <Ionicons name={`${icon}`} size={40} color={"#16a085"} />
      <Text
        className="text-lg text-gray-700 mb-2"
        style={{ fontFamily: "Inter_400Regular" }}
      >
        {number} {text}
      </Text>
    </View>
  );

  return (
    <SafeAreaView className="flex-1 bg-gray-200">
      <KeyboardAwareScrollView
        className="py-3"
        keyboardDismissMode="interactive"
        keyboardShouldPersistTaps="handled"
        scrollEnabled
        behavior="padding"
        contentContainerStyle={{
          paddingBottom: DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING,
          paddingHorizontal: 10,
        }}
      >
        <View className="bg-white mt-1 p-2 rounded-md">
          <Text
            className="text-lg text-gray-700 mb-2"
            style={{ fontFamily: "Inter_500Medium" }}
          >
            Statistiques
          </Text>
          <View className="flex-row flex-wrap items-center">
            <List number={totalCounts[0]} icon={"person"} text="utilisateurs" />
            <List number={totalCounts[1]} icon={"search"} text="recherchés" />
            <List number={totalCounts[2]} icon={"checkmark"} text="trouvés" />
            <List number={totalCounts[3]} icon={"logo-euro"} text="payés" />
          </View>
        </View>

        <View className="bg-white mt-3 p-2 rounded-md">
          <Text
            className="text-lg text-gray-700 mb-2"
            style={{ fontFamily: "Inter_500Medium" }}
          >
            Installations
          </Text>
          <View className="flex-row flex-wrap items-center">
            <List number={"+10K"} icon={"logo-android"} text="" />
            <List number={"+0"} icon={"phone-portrait"} text="" />
          </View>
          <Text
            className="text-base text-gray-600 mb-2"
            style={{ fontFamily: "Inter_400Regular" }}
          >
            Dernière vérification le 20/11/24
          </Text>
        </View>

        <View className="bg-white mt-3 p-2 rounded-md">
          <Text
            className="text-lg text-gray-700 mb-2"
            style={{ fontFamily: "Inter_500Medium" }}
          >
            Google Ads
          </Text>
          <Text
            className="text-base text-gray-600 mb-2"
            style={{ fontFamily: "Inter_400Regular" }}
          >
            Synchronisation en cours ...
          </Text>
        </View>

        <View className="bg-white mt-3 p-2 rounded-md">
          <Text
            className="text-lg text-gray-700 mb-2"
            style={{ fontFamily: "Inter_500Medium" }}
          >
            Données utilisateurs
          </Text>
          <View className="flex items-center justify-center">
            <LineChart
              data={data}
              width={screenWidth - 40}
              height={220}
              chartConfig={chartConfig}
              style={{ borderRadius: 5 }}
            />
            <View className="mt-4">
              <LineChart
                data={data2024}
                width={screenWidth - 40}
                height={220}
                chartConfig={chartConfig}
                style={{ borderRadius: 5 }}
              />
            </View>
          </View>
        </View>
      </KeyboardAwareScrollView>
    </SafeAreaView>
  );
}
