import { View } from "react-native";
import React, {  useLayoutEffect } from "react";
import { createMaterialTopTabNavigator } from "@react-navigation/material-top-tabs";
import { COLORS } from "../../styles/colors";
import { useSafeAreaInsets } from "react-native-safe-area-context";
import PaymentTransfered from "./PaymentTransfered";
import PaymentReceived from "./PaymentReceived";

export default function Payments({ navigation }) {
  const Tab = createMaterialTopTabNavigator();
  const insets = useSafeAreaInsets();

  useLayoutEffect(() => {
    navigation.setOptions({
      headerTitle: "Paiements",
      // header: () => (
      //   <View
      //     style={{ paddingTop: insets.top, backgroundColor: COLORS.primary }}
      //   ></View>
      // ),
    });
  });


  return (
    <Tab.Navigator
      screenOptions={{
        tabBarLabelStyle: {
          fontFamily: "Inter_500Medium",
          textTransform: "capitalize",
          color: "white",
        },
        tabBarStyle: { backgroundColor: COLORS.primary },
        tabBarIndicatorStyle: { backgroundColor: "orange" },
      }}
    >
      <Tab.Screen
        name="MySearchs"
        component={PaymentReceived}
        options={{
          title: "Reçus",
        }}
      />
      <Tab.Screen
        name="MyFinds"
        component={PaymentTransfered}
        options={{
          title: "A envoyer",
        }}
      />
    </Tab.Navigator>
  );
}
