import { View, Text, SafeAreaView, ScrollView } from "react-native";
import React, { useEffect, useLayoutEffect, useState } from "react";
import { Ionicons } from "@expo/vector-icons";
import * as Haptics from "expo-haptics";
import BackButton from "../../components/Buttons/BackButton";
import {
  DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING,
  INPUT_CLASS,
  INPUT_CLASS_BORDER_BOTTOM,
  TEXT_AREA_CLASS,
} from "../../styles/constants";
import PageSubTitle from "../../components/Titles/PageSubTitle";
import PrimaryButton from "../../components/Buttons/PrimaryButton";
import { KeyboardAwareScrollView } from "react-native-keyboard-aware-scroll-view";
import { TextInput } from "react-native";
import { addDoc, collection } from "firebase/firestore";
import { auth, db } from "../../../config/firebase";
import { Alert } from "react-native";
import moment from "moment";

export default function SendNotifications({ navigation, route }) {
  const { item } = route.params;
  const MAX_DESC_LENGTH = 250;
  const [isLoading, setIsLoading] = useState(false);
  const [title, setTitle] = useState("");
  const [desc, setDesc] = useState("");

  useLayoutEffect(() => {
    navigation.setOptions({
      headerLeft: () => <BackButton onPress={navigation.goBack} />,
      headerTitle: "",
      headerTitle: "Envoyer une notif",
    });
  }, [navigation]);


  const validate = async () => {
    setIsLoading(true);

    if (title == "" || desc == "") {
      Alert.alert("Aucun message");
      setIsLoading(false);
      return;
    }

    if (!item.expoPushToken) {
      Alert.alert(
        "Erreur d'envoi de la notification: ",
        `${
          item.firstName + " " + item.lastName
        } n'a pas activé les notifications pour Sur4Plots`
      );
      setIsLoading(false);
      return;
    }
    try {
      const MESSAGE = {
        to: item.expoPushToken,
        sound: "default",
        title: `${title}`,
        body: `${desc}`,
      };

      await fetch("https://exp.host/--/api/v2/push/send", {
        method: "POST",
        headers: {
          Accept: "application/json",
          "Accept-encoding": "gzip, deflate",
          "Content-Type": "application/json",
        },
        body: JSON.stringify(MESSAGE),
      });

      await addDoc(collection(db, "notifications"), {
        title: title,
        text: desc,
        isViewed: false,
        userId: item.id,
        createdAt: moment().format(),
      });

      await addDoc(collection(db, "adminNotificationsSended"), {
        title: title,
        text: desc,
        toUser: item.id,
        createdAt: moment().format(),
      });

      Alert.alert(
        "Notification envoyée",
        `${item.firstName + " " + item.lastName} a bien reçu la notif`,
        [{ text: "De rien", onPress: () => navigation.goBack() }]
      );
    } catch (e) {
      Alert.alert("Erreur d'envoi de la notification: ", `${e}`);
    } finally {
      setIsLoading(false);
    }
  };

  return (
    <SafeAreaView className="flex-1 bg-white">
      <KeyboardAwareScrollView
        className="p-4"
        keyboardDismissMode="interactive"
        keyboardShouldPersistTaps="handled"
        // resetScrollToCoords={{ x: 0, y: 0 }}
        scrollEnabled
        behavior="padding"
        contentContainerStyle={{
          paddingBottom: DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING,
        }}
      >
        {/* <View className="">
          <PageSubTitle title={"Laisser un avis"} />
        </View> */}

        <View className="mt-5">
          <Text
            className="text-sm mb-2 ml-1"
            style={{ fontFamily: "Inter_400Regular" }}
          >
            Votre notification pour{" "}
            <Text
              className="text-sm text-blue-500 underline mb-2 ml-1"
              style={{ fontFamily: "Inter_400Regular" }}
            >
              {item.firstName + " " + item.lastName} ({item.email})
            </Text>
          </Text>
          <View className="my-2">
            <TextInput
              style={{ fontFamily: "Inter_500Medium" }}
              className={INPUT_CLASS_BORDER_BOTTOM}
              placeholder="Titre"
              placeholderTextColor={"gray"}
              value={title}
              maxLength={MAX_DESC_LENGTH}
              onChangeText={(val) => {
                setTitle(val);
              }}
            />
          </View>
          <TextInput
            style={{ fontFamily: "Inter_500Medium" }}
            multiline
            textAlignVertical="top"
            className={TEXT_AREA_CLASS}
            placeholder="Court message"
            placeholderTextColor={"gray"}
            value={desc}
            maxLength={MAX_DESC_LENGTH}
            onChangeText={(val) => {
              setDesc(val);
            }}
          />
          <Text
            className="text-xs text-gray-500 mt-2 ml-1 self-end"
            style={{ fontFamily: "Inter_300Light" }}
          >
            {MAX_DESC_LENGTH - desc.length + " restants"}
          </Text>
        </View>
        {/* validate button */}
        <View className="flex-1 mt-10 w-full">
          <PrimaryButton
            text={"Envoyer"}
            isLoading={isLoading}
            onPress={validate}
          />
        </View>
      </KeyboardAwareScrollView>
    </SafeAreaView>
  );
}
