import React, { useEffect } from "react";
import { createBottomTabNavigator } from "@react-navigation/bottom-tabs";
import { createNativeStackNavigator } from "@react-navigation/native-stack";
import { NavigationContainer } from "@react-navigation/native";
import Login from "../screens/Auth/Login";
import Register from "../screens/Auth/Register";
import HowItsWork from "../screens/HowItsWork";
import Landing from "../screens/Landing";
import ForgotPassword from "../screens/Auth/ForgotPassword";

const Stack = createNativeStackNavigator();
const Tab = createBottomTabNavigator();

export default function AuthNav() {
  const HomeStack = () => {
    return (
      <Stack.Navigator
        // initialRouteName="Register"
        screenOptions={{
          headerStyle: { borderColor: "white" },
          contentStyle: { backgroundColor: "white" },
        }}
      >
        <Stack.Screen
          name="Landing"
          component={Landing}
          // options={{ presentation: "transparentModal" }}
        />

        <Stack.Screen name="Login" component={Login} />

        <Stack.Screen name="Register" component={Register} />
        <Stack.Screen name="ForgotPassword" component={ForgotPassword} />
        <Stack.Screen
          name="HowItsWork"
          component={HowItsWork}
          // options={{ headerShown: false }}
        />
      </Stack.Navigator>
    );
  };

  return (
    <NavigationContainer>
      <HomeStack></HomeStack>
    </NavigationContainer>
  );
}
