import React, { useEffect } from "react";
import { createBottomTabNavigator } from "@react-navigation/bottom-tabs";
import { createNativeStackNavigator } from "@react-navigation/native-stack";
import {
  NavigationContainer,
  getFocusedRouteNameFromRoute,
} from "@react-navigation/native";
import { Cog8ToothIcon } from "react-native-heroicons/solid";
import { Cog8ToothIcon as Cog8ToothIconOutline } from "react-native-heroicons/outline";
import Home from "../screens/Home";
import Search from "../screens/Search/Search";
import { COLORS } from "../styles/colors";
import Find from "../screens/Find";
import AddInfo from "../screens/User/AddInfo";
import Profile from "../screens/User/Profile";
import Notifications from "../screens/Notifications";
import { Ionicons } from "@expo/vector-icons";
import MyDemands from "../screens/User/MyDemands";
import CardIdentity from "../screens/User/CardIdentity";
import HowItsWork from "../screens/HowItsWork";
import WriteComment from "../screens/User/WriteComment";
import SignalBug from "../screens/User/SignalBug";
import MyRIB from "../screens/User/MyRIB";
import Pay from "../screens/Pay";
import ValidateProfileStep1 from "../screens/User/Validate/ValidateProfileStep1";
import Tips from "../screens/Tips";
import PersonalInformations from "../screens/User/PersonalInformations";
import SendRib from "../screens/User/Validate/SendRib";
import Landing from "../screens/Landing";
import Login from "../screens/Auth/Login";
import Register from "../screens/Auth/Register";
import ForgotPassword from "../screens/Auth/ForgotPassword";
import ValidateProfileStep2 from "../screens/User/Validate/ValidateProfileStep2";
import ChangeLanguage from "../screens/ChangeLanguage";
import { useTranslation } from "react-i18next";
import Test from "../screens/Test";
import SearchStep1 from "../screens/Search/SearchStep1";
import SearchStep2 from "../screens/Search/SearchStep2";
import SearchStep3 from "../screens/Search/SearchStep3";

const Stack = createNativeStackNavigator();
const Tab = createBottomTabNavigator();
const NAV_ICON_DEFAULT_SIZE = 22;

export default function Navigator() {
  const { t } = useTranslation();
  const HomeStack = () => {
    return (
      <Stack.Navigator
        // initialRouteName="Landing"
        screenOptions={{
          headerStyle: { borderColor: "white" },
          contentStyle: { backgroundColor: "white" },
          headerTitleStyle: { fontFamily: "Inter_500Medium" },
        }}
      >
        <Stack.Screen name="HomeScreen" component={Home} />
        <Stack.Screen name="Profile" component={Profile} />
      </Stack.Navigator>
    );
  };

  const DemandsStack = () => {
    return (
      <Stack.Navigator
        screenOptions={{
          headerStyle: { borderColor: "white" },
          contentStyle: { backgroundColor: "white" },
          headerTitleStyle: { fontFamily: "Inter_500Medium" },
        }}
      >
        <Stack.Screen
          name="MyDemands"
          component={MyDemands}
          // options={{ headerShown: false }}
        />
        <Stack.Screen
          name="Pay"
          component={Pay}
          options={{ presentation: "modal" }}
        />
      </Stack.Navigator>
    );
  };

  function HomeTabs() {
    return (
      <Tab.Navigator
        screenOptions={{
          tabBarActiveTintColor: COLORS.primary,

          tabBarShowLabel: true,
          tabBarLabelStyle: {
            fontSize: 12,
            fontFamily: "Inter_300Light",
          },
        }}
      >
        <Tab.Screen
          name="Home"
          component={HomeStack}
          options={{
            headerShown: false,
            title: t("navigator.one"),
            tabBarIcon: ({ focused }) =>
              focused ? (
                <Ionicons
                  color={COLORS.primary}
                  name="home"
                  size={NAV_ICON_DEFAULT_SIZE}
                />
              ) : (
                <Ionicons
                  color={"#2d3436"}
                  name="home-outline"
                  size={NAV_ICON_DEFAULT_SIZE}
                />
              ),
          }}
        />
        <Tab.Screen
          name="DemandsTab"
          component={DemandsStack}
          options={{
            headerShown: false,
            title: t("navigator.two"),
            tabBarIcon: ({ focused }) =>
              focused ? (
                <Ionicons
                  name="bookmark"
                  size={NAV_ICON_DEFAULT_SIZE}
                  color={COLORS.primary}
                />
              ) : (
                <Ionicons
                  name="bookmark-outline"
                  size={NAV_ICON_DEFAULT_SIZE}
                  color="#2d3436"
                />
              ),
          }}
        />

        <Tab.Screen
          name="NotifTab"
          component={Notifications}
          options={{
            title: t("navigator.three"),
            tabBarIcon: ({ focused }) =>
              focused ? (
                <Ionicons
                  name="notifications"
                  size={NAV_ICON_DEFAULT_SIZE}
                  color={COLORS.primary}
                />
              ) : (
                <Ionicons
                  name="notifications-outline"
                  size={NAV_ICON_DEFAULT_SIZE}
                  color="#2d3436"
                />
              ),
          }}
        />
      </Tab.Navigator>
    );
  }

  return (
    <NavigationContainer>
      <Stack.Navigator>
        <Stack.Screen
          name="HomeTab"
          component={HomeTabs}
          options={{ headerShown: false }}
        />
        {/* <Stack.Screen name="Search" component={Search} /> */}
        <Stack.Screen name="SearchStep1" component={SearchStep1} />
        <Stack.Screen name="SearchStep2" component={SearchStep2} />
        <Stack.Screen name="SearchStep3" component={SearchStep3} />
        <Stack.Screen name="Find" component={Find} />
        <Stack.Screen name="SendRib" component={SendRib} />
        <Stack.Screen
          name="PersonalInformations"
          component={PersonalInformations}
        />
        <Stack.Screen name="ChangeLanguage" component={ChangeLanguage} />
        <Stack.Screen name="Tips" component={Tips} />
        <Stack.Screen name="HowItsWork" component={HowItsWork} />
        <Stack.Screen name="SignalBug" component={SignalBug} />
        <Stack.Screen name="WriteComment" component={WriteComment} />
        <Stack.Screen
          name="ValidateProfileStep1"
          component={ValidateProfileStep1}
        />
        <Stack.Screen
          name="ValidateProfileStep2"
          component={ValidateProfileStep2}
        />

        {/* AUTH NAV */}
        <Stack.Screen
          name="Landing"
          component={Landing}
          // options={{ presentation: "transparentModal" }}
        />
        <Stack.Screen name="Login" component={Login} />
        <Stack.Screen name="Register" component={Register} />
        <Stack.Screen name="ForgotPassword" component={ForgotPassword} />
        <Stack.Screen name="Test" component={Test} />
      </Stack.Navigator>
    </NavigationContainer>
  );
}
