import { View, Alert } from "react-native";
import React, { useEffect, useLayoutEffect, useRef, useState } from "react";
import StepIndicator from "react-native-step-indicator";
import PagerView from "react-native-pager-view"; // Si vous utilisez PagerView
import SearchStep1 from "./SearchStep1";
import SearchStep2 from "./SearchStep2";
import SearchStep3 from "./SearchStep3";
import BackButton from "../../components/Buttons/BackButton";
import PrimaryButton from "../../components/Buttons/PrimaryButton";

const labels = ["Pays", "Type de véhicule", "Informations"];

const customStyles = {
  stepIndicatorSize: 25,
  currentStepIndicatorSize: 30,
  separatorStrokeWidth: 2,
  currentStepStrokeWidth: 3,
  stepStrokeCurrentColor: "#fe7013",
  stepStrokeWidth: 3,
  stepStrokeFinishedColor: "#fe7013",
  stepStrokeUnFinishedColor: "#aaaaaa",
  separatorFinishedColor: "#fe7013",
  separatorUnFinishedColor: "#aaaaaa",
  stepIndicatorFinishedColor: "#fe7013",
  stepIndicatorUnFinishedColor: "#ffffff",
  stepIndicatorCurrentColor: "#ffffff",
  stepIndicatorLabelFontSize: 13,
  currentStepIndicatorLabelFontSize: 13,
  stepIndicatorLabelCurrentColor: "#fe7013",
  stepIndicatorLabelFinishedColor: "#ffffff",
  stepIndicatorLabelUnFinishedColor: "#aaaaaa",
  labelColor: "#999999",
  labelSize: 13,
  currentStepLabelColor: "#fe7013",
};
export default function Search({ navigation, route }) {
  const { userInfo } = route.params;
  const stepRefs = [useRef(), useRef(), useRef()];
  const pagerViewRef = useRef(null);
  const [currentPage, setCurrentPage] = useState(0);
  const [formData, setFormData] = useState({
    step1: {},
    step2: {},
    step3: {},
  });

  useLayoutEffect(() => {
    navigation.setOptions({
      headerLeft: () => (
        <BackButton
          text={"Annuler"}
          color={"red"}
          onPress={() =>
            Alert.alert(
              "Annuler la recherche",
              "Voulez-vous vraiment l'annuler?",
              [
                {
                  text: "Annuler",
                  style: "cancel",
                  onPress: () => navigation.goBack(),
                },
                {
                  text: "Continuer",
                },
              ],
              {
                cancelable: true,
              }
            )
          }
        />
      ),
      headerTitle: "Rechercher un véhicule",
      headerRight: () => (
        <BackButton
          next
          text={currentPage === 3 ? "Publier" : "Suivant"}
          color={"#3498db"}
          onPress={() => stepRefs[currentPage].current.validate()}
        />
      ),
    });
  }, [navigation, currentPage]);

  useEffect(() => {
    navigation
      .getParent()
      ?.setOptions({ tabBarStyle: { display: "none" }, tabBarVisible: false });
    return () =>
      navigation
        .getParent()
        ?.setOptions({ tabBarStyle: undefined, tabBarVisible: undefined });
  }, [navigation]);

  const goToNextPage = () => {
    if (currentPage < labels.length - 1) {
      const nextPage = currentPage + 1;
      setCurrentPage(nextPage);
      pagerViewRef.current?.setPage(nextPage);
    }
  };

  const goToPreviousPage = () => {
    if (currentPage > 0) {
      const prevPage = currentPage - 1;
      setCurrentPage(prevPage);
      pagerViewRef.current?.setPage(prevPage);
    }
  };

  const updateStepData = (step, data) => {
    setFormData((prevFormData) => ({
      ...prevFormData,
      [step]: data,
    }));
  };

  return (
    <View className="flex-1 pt-5 bg-white">
      <StepIndicator
        customStyles={customStyles}
        currentPosition={currentPage}
        labels={labels}
        stepCount={labels.length}
      />
      <PagerView
        scrollEnabled={false}
        style={{ flexGrow: 1 }}
        initialPage={0}
        onPageSelected={(e) => setCurrentPage(e.nativeEvent.position)}
        ref={pagerViewRef}
      >
        <SearchStep1
          ref={stepRefs[0]}
          goToNextPage={goToNextPage}
          updateStepData={updateStepData}
        />
        <SearchStep2
          ref={stepRefs[1]}
          goToNextPage={goToNextPage}
          updateStepData={updateStepData}
        />
        <SearchStep3
          userInfo={userInfo}
          formData={formData}
          ref={stepRefs[2]}
          goToNextPage={goToNextPage}
          updateStepData={updateStepData}
        />
      </PagerView>
      <View
        style={{
          flexDirection: "row",
          justifyContent: "space-between",
          gap: 5,
          padding: 20,
        }}
      >
        {currentPage > 0 && (
          <View className="flex-grow w-1/2">
            <PrimaryButton
              outline
              text={"Précédent"}
              isLoading={false}
              onPress={goToPreviousPage}
            />
          </View>
        )}
        {/* {currentPage < labels.length - 1 && (
          <View className="flex-grow w-1/2">
            <PrimaryButton
              text={"Suivant"}
              isLoading={false}
              onPress={() => stepRefs[currentPage].current.validate()}
            />
          </View>
        )} */}

        {currentPage === 2 && (
          <View className="flex-grow w-1/2">
            <PrimaryButton
              text={"Rechercher"}
              isLoading={false}
              onPress={() => stepRefs[currentPage].current.validate()}
            />
          </View>
        )}
      </View>
    </View>
  );
}
