import { View, Text, Image } from "react-native";
import React, { useEffect, useLayoutEffect, useState } from "react";
import { SafeAreaView } from "react-native";
import BackButton from "../components/Buttons/BackButton";
import PageLoader from "../components/Loaders/PageLoader";
import sendAdminNotif from "../utils/sendAdminNotif";
import { FlashList } from "@shopify/flash-list";
import { useTranslation } from "react-i18next";
import { TIPS, TIPS_EN } from "../utils/tips";
import {
  Collapse,
  CollapseHeader,
  CollapseBody,
  AccordionList,
} from "accordion-collapse-react-native";
import PageTitle from "../components/Titles/PageTitle";
import { Ionicons } from "@expo/vector-icons";


export default function Tips({ navigation, }) {
  const { t, i18n } = useTranslation();

  const [isLoading, setIsLoading] = useState(true);

  useLayoutEffect(() => {
    navigation.setOptions({
      headerLeft: () => <BackButton onPress={navigation.goBack} />,
      headerTitle: "Conseils",
    });
  });

  useEffect(() => {
    sendAdminNotif(`Un utilisateur a consulte la section Conseils`);
    setTimeout(() => {
      setIsLoading(false);
    }, 200);
  }, []);

  if (isLoading) {
    return <PageLoader />;
  }

  return (
    <SafeAreaView className="flex-1 bg-gray-100">
      <View className="flex-1 px-4">
        <FlashList
          data={i18n?.language == "en" ? TIPS_EN : TIPS}
          ListHeaderComponent={() => (
            <View className="mt-7 mb-4">
              <PageTitle title={t("screens.home.vehicleLost")} />
              <Text
                style={{ fontFamily: "Inter_300Light" }}
                className="text-sm mb-1"
              >
                {t("screens.home.vehicleLostInfo")}
              </Text>
            </View>
          )}
          renderItem={({ item, index }) => (
            <View className="border border-gray-200">
              <Collapse>
                <CollapseHeader>
                  <View className="flex-row items-center justify-between p-3">
                    <Image source={item.img} className="w-10 h-10 z-20" />
                    <View className="mx-2 flex-1">
                      <Text
                        style={{ fontFamily: "Inter_500Medium" }}
                        className="text-base"
                      >
                        {item.title}
                      </Text>
                    </View>
                    <Ionicons
                      name={"chevron-down-outline"}
                      size={18}
                      color={"gray"}
                    />
                  </View>
                </CollapseHeader>
                <CollapseBody>
                  <Text
                    style={{ fontFamily: "Inter_400Regular" }}
                    className="px-3 pb-3 text-sm text-gray-700"
                  >
                    {item.desc}
                  </Text>
                </CollapseBody>
              </Collapse>
            </View>
          )}
          keyExtractor={(item) => item.title.toString()}
          estimatedItemSize={20}
        />
      </View>
    </SafeAreaView>
  );
}
