import { View, Text } from "react-native";
import React, {
  useCallback,
  useEffect,
  useMemo,
  useRef,
  useState,
} from "react";
import { auth, db } from "../../../config/firebase";
import {
  collection,
  getDocs,
  onSnapshot,
  query,
  where,
} from "firebase/firestore";
import { Pressable } from "react-native";
import { SafeAreaView } from "react-native";
import { FlatList } from "react-native";
import moment from "moment";
import { COLORS } from "../../styles/colors";
import { TouchableOpacity } from "react-native";
import { Ionicons } from "@expo/vector-icons";
import BottomSheet, {
  BottomSheetBackdrop,
  BottomSheetModal,
  BottomSheetModalProvider,
  BottomSheetScrollView,
  BottomSheetView,
} from "@gorhom/bottom-sheet";
import * as Haptics from "expo-haptics";
import { Alert } from "react-native";
import { useFocusEffect } from "@react-navigation/native";
import { Image } from "react-native";
import Loader from "../../components/Loaders/Loader";
import PageLoader from "../../components/Loaders/PageLoader";
import { DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING } from "../../styles/constants";
import SmallPrimaryButton from "../../components/Buttons/SmallPrimaryButton";
import { useTranslation } from "react-i18next";

export default function MyFinds({ navigation }) {
  const { t } = useTranslation();
  const [data, setData] = useState("");
  const [isLoading, setIsLoading] = useState(true);
  const [modalData, setModalData] = useState(null);

  useEffect(() => {
    getFinds();
    return () => {};
  }, []);

  async function getFinds() {
    const q = query(
      collection(db, "searchs"),
      where("finderId", "==", auth.currentUser.uid)
    );
    const querySnapshot = await getDocs(q);
    const dataArr = [];
    querySnapshot.forEach(async (res) => {
      dataArr.push({
        id: res.id,
        ...res.data(),
      });
    });
    setData(dataArr);
    setTimeout(() => {
      setIsLoading(false);
    }, 500);
  }

  const bottomSheetModalRef = useRef(null);

  // variables
  const snapPoints = useMemo(() => ["90%"], []);

  // callbacks
  const openModal = useCallback((item) => {
    setModalData(item);
    setTimeout(() => {
      bottomSheetModalRef.current?.present();
    }, 100);
  }, []);

  const closeModal = useCallback(() => {
    bottomSheetModalRef.current?.dismiss();
  }, []);

  const renderBackdrop = useCallback(
    (props) => (
      <BottomSheetBackdrop
        {...props}
        disappearsOnIndex={-1}
        // appearsOnIndex={1}
      />
    ),
    []
  );

  const Card = ({ item }) => (
    <Pressable
      className="p-3 bg-gray-50 border border-gray-200 mb-5 rounded-md flex-row items-center justify-between"
      onPress={() => openModal(item)}
    >
      <View className="flex-1 flex-row items-center">
        <View>
        <View className="flex-row items-center">
            <Text
              className="text-base"
              style={{ fontFamily: "Inter_400Regular" }}
            >
              {t('my_finds_screen.licensePlateTitle')}: {item?.plate?.toUpperCase()}
            </Text>
          </View>
          <View className="my-1 flex-row items-center">
            <Text
              className="text-base capitalize"
              style={{ fontFamily: "Inter_400Regular" }}
            >
              {t('my_finds_screen.insuranceTitle')}: {item?.assurance?.toUpperCase()}
            </Text>
          </View>
          <View className="mt-1 flex-row items-center">
            {item.status == "progress" ? (
              <Ionicons name="checkmark-outline" size={15} color="orange" />
            ) : (
              <Ionicons name="checkmark-outline" size={15} color="#27ae60" />
            )}
            <Text
              className="text-base ml-1 text-gray-700"
              style={{ fontFamily: "Inter_300Light" }}
            >
              {item.finderPaymentStatus == "paid" ? t('my_finds_screen.alreadyPaid') : t('my_finds_screen.notPaidYet')}
            </Text>
          </View>
        </View>
      </View>
      <View className="w-2/12">
        <SmallPrimaryButton
          onPress={() => openModal(item)}
          text={""}
        />
      </View>
    </Pressable>
  );

  const CardList = ({ title, value }) => (
    <View className="py-2">
      <Text
        className="text-gray-500 text-base"
        style={{ fontFamily: "Inter_300Light" }}
      >
        {title}
      </Text>
      <Text
        className="uppercase text-lg"
        style={{ fontFamily: "Inter_400Regular" }}
      >
        {value}
      </Text>
    </View>
  );

  if (isLoading) {
    return <PageLoader />;
  }

  if (!data.length) {
    return (
      <View className="flex-1 bg-white items-center justify-center px-[10%] -mt-[50%]">
        <Image
          source={require("../../../assets/img/x.png")}
          resizeMode="contain"
          className="w-24 h-24"
        />
        <Text
          className="text-base text-center text-black mt-10 mb-2"
          style={{ fontFamily: "Inter_500Medium" }}
        >
          {t('my_finds_screen.notFound')}
        </Text>
        <Text className="text-sm text-center text-gray-700">
          {t('my_finds_screen.notFoundMessage')}
        </Text>
      </View>
    );
  }

  return (
    <SafeAreaView className="flex-1 bg-white">
      <FlatList
        className="p-4"
        contentContainerStyle={{
          paddingBottom: DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING,
        }}
        keyExtractor={(item) => item.id}
        data={data}
        renderItem={({ item }) => <Card item={item} />}
      />
      <BottomSheetModalProvider>
        <View className="flex-1">
          <BottomSheetModal
            ref={bottomSheetModalRef}
            backdropComponent={renderBackdrop}
            index={0}
            snapPoints={snapPoints}
          >
            <BottomSheetScrollView
              contentContainerStyle={{
                paddingBottom: DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING,
              }}
            >
              <View className="pb-4 px-4">
                <Text
                  className="text-xl py-2"
                  style={{ fontFamily: "Inter_500Medium" }}
                >
                  {t('my_finds_screen.infoHeader')}
                </Text>
                <Pressable
                  onPress={() => {
                    closeModal();
                    setTimeout(() => {
                      navigation.navigate("Profile");
                    }, 200);
                  }}
                  className="flex-row p-2 border rounded-md border-gray-300"
                >
                    <Text
                      className="text-base"
                      style={{
                        fontFamily: "Inter_400Regular",
                        color: COLORS.primary,
                      }}
                    >
                      {t('my_finds_screen.bankDetailsRequest')}
                    </Text>
                </Pressable>
                <CardList
                  title={t('my_finds_screen.licensePlateTitle')}
                  value={modalData?.plate}
                />
              
                <CardList
                  title={t('my_finds_screen.lastPositionTitle')}
                  value={
                    modalData?.address.street +
                    " · " +
                    modalData?.address.city +
                    " " +
                    modalData?.address.postalCode +
                    ", " +
                    modalData?.address.country
                  }
                />
                <CardList
                  title={t('my_finds_screen.publishedOnTitle')}
                  value={moment(modalData?.createdAt).format(
                    "DD/MM/YYYY à hh:mm a"
                  )}
                />
                <CardList
                  title={t('my_finds_screen.statusTitle')}
                  value={
                    modalData?.status == "ended"
                      ? "Retrouvée"
                      : "Encore en recherche"
                  }
                />

                <CardList
                  title={t('my_finds_screen.paidTitle')}
                  value={
                    modalData?.paymentStatus == "unpaid"
                      ? t('my_finds_screen.notPaidYet')
                      : t('my_finds_screen.alreadyPaid')
                  }
                />
              </View>
            </BottomSheetScrollView>
          </BottomSheetModal>
        </View>
      </BottomSheetModalProvider>
    </SafeAreaView>
  );
}
