import {
  View,
  Text,
  SafeAreaView,
  Alert,
  TextInput,
  Platform,
} from "react-native";
import React, { useEffect, useLayoutEffect, useState } from "react";
import { Ionicons } from "@expo/vector-icons";
import * as Haptics from "expo-haptics";
import BackButton from "../../../components/Buttons/BackButton";
import {
  DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING,
  INPUT_CLASS,
  INPUT_CLASS_BORDER_BOTTOM,
  INPUT_CLASS_STYLE_OPEN,
  mySelectStyle,
} from "../../../styles/constants";
import PageSubTitle from "../../../components/Titles/PageSubTitle";
import PrimaryButton from "../../../components/Buttons/PrimaryButton";
import { KeyboardAwareScrollView } from "react-native-keyboard-aware-scroll-view";
import * as ImagePicker from "expo-image-picker";
import RNPickerSelect from "react-native-picker-select";
import Icon from "../../../components/Icons";

export default function ValidateProfileStep1({ navigation }) {
  const [isLoading, setIsLoading] = useState(false);
  const [type, setType] = useState("cni");
  const [idNumber, setIdNumber] = useState("");

  useLayoutEffect(() => {
    navigation.setOptions({
      headerLeft: () => <BackButton onPress={navigation.goBack} />,
      headerTitle: "Vérifier mes documents",
    });
  }, [navigation]);

  useEffect(() => {
    navigation
      .getParent()
      ?.setOptions({ tabBarStyle: { display: "none" }, tabBarVisible: false });
    return () =>
      navigation
        .getParent()
        ?.setOptions({ tabBarStyle: undefined, tabBarVisible: undefined });
  }, [navigation]);

  const validate = async () => {
    setIsLoading(true);

    if (
      idNumber == "" ||
      type == "" ||
      !type ||
      (type !== "cni" && type !== "passport" && type !== "drivinglicense")
    ) {
      Alert.alert(
        "Veuillez choisir un type de document et rentrer son numéro d'identifiant",
        "Nous avons besoin de ces informations pour maintenir notre application en sécurité"
      );

      setIsLoading(false);
      return;
    }

    setIsLoading(false);
    const data = { type, idNumber };
    navigation.navigate("ValidateProfileStep2", { data });
  };

  const pickImage = async (value) => {
    const { status } = await ImagePicker.requestMediaLibraryPermissionsAsync();
    if (status !== "granted") {
      return;
    }

    const result = await ImagePicker.launchImageLibraryAsync({
      mediaTypes: ImagePicker.MediaTypeOptions.Images,
      allowsEditing: true,
      aspect: [4, 3],
      quality: 1,
    });

    if (!result.canceled) {
      if (value == 1) {
        setRecto(result.assets[0].uri);
      } else if (value == 2) {
        setVerso(result.assets[0].uri);
      } else {
        return;
      }
    }
  };

  const pickeFacePhoto = async () => {
    const { status } = await ImagePicker.requestCameraPermissionsAsync();
    if (status !== "granted") {
      return;
    }

    const result = await ImagePicker.launchCameraAsync({
      mediaTypes: ImagePicker.MediaTypeOptions.Images,
      allowsEditing: true,
      aspect: [4, 3],
      quality: 1,
    });

    if (!result.canceled) {
      setFace(result.assets[0].uri);
    }
  };

  return (
    <SafeAreaView className="flex-1 bg-white">
      <KeyboardAwareScrollView
        className="p-4"
        keyboardDismissMode="interactive"
        keyboardShouldPersistTaps="handled"
        // resetScrollToCoords={{ x: 0, y: 0 }}
        scrollEnabled
        behavior="padding"
        contentContainerStyle={{
          paddingBottom: DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING,
        }}
      >
        <View className="">
          <PageSubTitle title={"Pièces acceptées"} />
          <Text
            className="text-sm text-gray-500 mb-3"
            style={{ fontFamily: "Inter_400Regular" }}
          >
            Pièce d'identité (CNI), passeport ou permis de conduire
          </Text>
          <Text
              style={{ fontFamily: "Inter_500Medium" }}
              className="text-sm py-2 px-1"
            >
              Type de document
            </Text>
          <RNPickerSelect
            Icon={() =>
              Platform.OS === "ios" && (
                <View className="mt-1">
                  <Icon bgNone icon={"chevron-down-outline"} w={20} />
                </View>
              )
            }
            style={{
              inputIOS: mySelectStyle,
              inputAndroid: mySelectStyle,
              placeholder: { color: "black" },
            }}
            doneText={"Valider"}
            onValueChange={(value) => setType(value)}
            value={type}
            items={[
              { label: "Carte nationale d'identité (CNI)", value: "cni" },
              { label: "Passeport", value: "passport" },
              { label: "Permis de conduire", value: "drivinglicense" },
            ]}
            placeholder={{}}
          />
        </View>
        <View className="">
          <View className="w-full mt-3">
            <TextInput
              style={{ fontFamily: "Inter_500Medium" }}
              className={INPUT_CLASS_BORDER_BOTTOM}
              placeholder="Numéro du document *"
              placeholderTextColor={"gray"}
              value={idNumber}
              onChangeText={(val) => {
                setIdNumber(val.toUpperCase());
              }}
            />
            <Text
              className="text-xs text-gray-400 mt-3 ml-1"
              style={{ fontFamily: "Inter_400Regular" }}
            >
              NB: Il se trouve généralement sur le document en question, il est
              composé d'une suite de lettres et souvent de chiffres
            </Text>
          </View>
        </View>
        {/* reservation button */}
        <View className="flex-1 w-full mt-10">
          <PrimaryButton
            text={"Continuer"}
            isLoading={isLoading}
            onPress={validate}
          />
        </View>
      </KeyboardAwareScrollView>
    </SafeAreaView>
  );
}
