import React, { useEffect, useState } from "react";
import { db } from "../config/firebase";
import {
  collection,
  getDocs,
  query,
  where,
  addDoc,
  getDoc,
  doc,
} from "firebase/firestore";
import PageTemplate from "../templates/PageTemplate";
import moment from "moment/moment";
import Table from "@mui/material/Table";
import TableBody from "@mui/material/TableBody";
import TableCell from "@mui/material/TableCell";
import TableContainer from "@mui/material/TableContainer";
import TableHead from "@mui/material/TableHead";
import TableRow from "@mui/material/TableRow";
import Paper from "@mui/material/Paper";

export default function Searchs() {
  const [data, setData] = useState([]);
  const [isLoading, setIsLoading] = useState(true);

  useEffect(() => {
    getSearchs();
  }, []);

  async function getSearchs() {
    const q = query(collection(db, "searchs"));
    const querySnapshot = await getDocs(q);
    const dataArr = [];
    querySnapshot.forEach(async (res) => {
      const getSearchName = await getDoc(doc(db, "users", res.data().userId));
      dataArr.push({
        id: res.id,
        ...res.data(),
        searcherName:
          getSearchName.data().lastName + " " + getSearchName.data().firstName,
        searcherEmail:
          getSearchName.data().email,
      });

      setData(dataArr);
    });
    setIsLoading(false);
  }

  if (isLoading) return null;
  return (
    <PageTemplate
      title={"Véhicules recherchés" + " (" + data.length + ")"}
      content={
        <div>
          <TableContainer component={Paper}>
            <Table sx={{ minWidth: 650 }} aria-label="simple table">
              <TableHead>
                <TableRow>
                  <TableCell>Plaque</TableCell>
                  <TableCell>Type</TableCell>
                  <TableCell>Chercheur</TableCell>
                  <TableCell>Email</TableCell>
                  <TableCell>Publié le</TableCell>
                  <TableCell>Retrouvé ?</TableCell>
                  <TableCell>A payé(e)</TableCell>
                </TableRow>
              </TableHead>
              <TableBody>
                {data.map((row) => (
                  <TableRow
                    key={row.id}
                    sx={{ "&:last-child td, &:last-child th": { border: 0 } }}
                  >
                    <TableCell component="th" scope="row">
                      {row.plate}
                    </TableCell>
                    <TableCell component="th" scope="row">
                      {row.type}
                    </TableCell>
                    <TableCell>{row.searcherName}</TableCell>
                    <TableCell>{row.searcherEmail}</TableCell>
                    <TableCell>
                      {moment(row.createdAt).format("DD/MM/YYYY h:mm a")}
                    </TableCell>
                    <TableCell>
                      {row.status == "ended" ? (
                        <i class="fa-solid fa-check text-xl text-green-500"></i>
                      ) : (
                        <i class="fa-solid fa-x text-xl text-red-500"></i>
                      )}
                    </TableCell>

                    <TableCell>
                      {row.paymentStatus == "paid" ? (
                        <i class="fa-solid fa-check text-xl text-green-500"></i>
                      ) : (
                        <i class="fa-solid fa-x text-xl text-red-500"></i>
                      )}
                    </TableCell>
                  </TableRow>
                ))}
              </TableBody>
            </Table>
          </TableContainer>
        </div>
      }
    />
  );
}
