import {
  View,
  Text,
  SafeAreaView,
  Pressable,
  Alert,
  StyleSheet,
  TouchableOpacity,
  ImageBackground,
} from "react-native";
import React, { useEffect, useLayoutEffect, useState } from "react";
import * as Haptics from "expo-haptics";
import BackButton from "../components/Buttons/BackButton";
import {
  DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING,
  LINEAR_COLOR,
  UPLOAD_PARAMS,
} from "../styles/constants";
import { KeyboardAwareScrollView } from "react-native-keyboard-aware-scroll-view";
import UserProfilePicture from "../components/Profile/UserProfilePicture";
import { LinearGradient } from "expo-linear-gradient";
import Icon from "../components/Icons";
import { auth, db, storage } from "../../config/firebase";
import { getDownloadURL, ref, uploadBytesResumable } from "firebase/storage";
import { doc, updateDoc } from "firebase/firestore";
import Loader from "../components/Loaders/Loader";
import {
  formatNumber,
  imageCompressor,
  openSettings,
} from "../utils/allFunctions";
import { Ionicons } from "@expo/vector-icons";
import { useNavigation } from "@react-navigation/native";


export default function ProfileTopCard({ userInfo, getUserInfo }) {
  const navigation = useNavigation();
  const ICON_SIZE = 30;
  const [isLoading, setIsLoading] = useState(false);



  const handleImagePickerResult = async (result) => {
    setIsLoading(true);
    if (result.canceled) {
      setIsLoading(false);
      return;
    }

    const finalImage = await imageCompressor(result.assets[0].uri);
    const res = await uploadProfilePicture(finalImage);
    await updateDoc(doc(db, "users", auth.currentUser.uid), {
      profilPhotoUrl: res,
    });
    getUserInfo();
    setIsLoading(false);
  };

  const uploadProfilePicture = async (image) => {
    try {
      const response = await fetch(image);

      const blobFile = await response.blob();
      const storageRef = ref(
        storage,
        `profile_pictures_/${auth.currentUser.uid}/` + "_" + Date.now()
      );

      const snapshot = await uploadBytesResumable(storageRef, blobFile);

      const imageUrl = await getDownloadURL(snapshot?.ref);
      return imageUrl;
    } catch (error) {
      console.error("Error uploading or retrieving image:", error);
    }
  };

  const removeProfilePicture = async () => {
    await updateDoc(doc(db, "users", auth.currentUser.uid), {
      profilPhotoUrl: "",
    });
    getUserInfo();
  };

  return (
    <View className="h-[15vh] relative mb-24">
      

      {/* Overlay sombre */}
      <View
        className="absolute flex-1 top-0"
        style={{
          ...StyleSheet.absoluteFillObject,
          backgroundColor: "rgba(0, 0, 0, 0)",
          justifyContent: "center",
          alignItems: "center",
        }}
      ></View>
      {/* absolute view */}
      <View className="-top-[5%] px-4">
        {/* profile picture */}
       
      </View>
    </View>
  );
}
