import React, { useEffect } from "react";
import { createBottomTabNavigator } from "@react-navigation/bottom-tabs";
import { createNativeStackNavigator } from "@react-navigation/native-stack";
import {
  NavigationContainer,
  getFocusedRouteNameFromRoute,
} from "@react-navigation/native";
import { Cog8ToothIcon } from "react-native-heroicons/solid";
import { Cog8ToothIcon as Cog8ToothIconOutline } from "react-native-heroicons/outline";
import { COLORS } from "../styles/colors";
import { Ionicons } from "@expo/vector-icons";
import Users from "../screens/Users/Users";
import Categories from "../screens/Categories/Categories";
import EditCategory from "../screens/Categories/EditCategory";
import SendNotifications from "../screens/Users/SendNotifications";
import Home from "../screens/Home";
import Searchs from "../screens/Searchs/Searchs";
import SearchDetails from "../screens/Searchs/SearchDetails";
import UserDetails from "../screens/Users/UserDetails";
import FindedSearchs from "../screens/Searchs/FindedSearchs";
import Payments from "../screens/Payments/Payments";
import Menu from "../screens/Menu";
import Finders from "../screens/Users/Finders";
import Searchers from "../screens/Users/Searchers";
import EditCGV from "../screens/EditCGV";
import EditMentions from "../screens/EditMentions";
import EditHowItsWork from "../screens/EditHowItsWork";
import SearchPlaque from "../screens/SearchPlaque";
import SearchUser from "../screens/SearchUser";
import FinderDetails from "../screens/Users/FinderDetails";
import ShowBugs from "../screens/ShowBugs";
import ShowComments from "../screens/ShowComments";

const Stack = createNativeStackNavigator();
const Tab = createBottomTabNavigator();

const NAV_ICON_DEFAULT_SIZE = 24;
export default function Navigator() {
  const HomeStack = () => {
    return (
      <Stack.Navigator
        screenOptions={{
          headerStyle: { borderColor: "white" },
          contentStyle: { backgroundColor: "white" },
          headerTitleStyle: { fontFamily: "Inter_500Medium" },
        }}
      >
        <Stack.Screen name="Home" component={Home} />
      </Stack.Navigator>
    );
  };

  const SearchStack = () => {
    return (
      <Stack.Navigator
        screenOptions={{
          headerStyle: { borderColor: "white" },
          contentStyle: { backgroundColor: "white" },
          headerTitleStyle: { fontFamily: "Inter_500Medium" },
        }}
      >
        <Stack.Screen name="SearchPlaque" component={SearchPlaque} />
        <Stack.Screen name="SearchDetails" component={SearchDetails} />
      </Stack.Navigator>
    );
  };

  const SearchUserStack = () => {
    return (
      <Stack.Navigator
        screenOptions={{
          headerStyle: { borderColor: "white" },
          contentStyle: { backgroundColor: "white" },
          headerTitleStyle: { fontFamily: "Inter_500Medium" },
        }}
      >
        <Stack.Screen name="SearchUser" component={SearchUser} />
        <Stack.Screen name="UserDetails" component={UserDetails} />
      </Stack.Navigator>
    );
  };

  const MenuStack = () => {
    return (
      <Stack.Navigator
        screenOptions={{
          headerStyle: { borderColor: "white" },
          contentStyle: { backgroundColor: "white" },
          headerTitleStyle: { fontFamily: "Inter_500Medium" },
        }}
      >
        <Stack.Screen name="Menu" component={Menu} />
        <Stack.Screen
          name="Payments"
          component={Payments}
          options={{ title: "Paiements" }}
        />
        <Stack.Screen name="Searchs" component={Searchs} />
        <Stack.Screen name="FindedSearchs" component={FindedSearchs} />
        <Stack.Screen name="SearchDetails" component={SearchDetails} />
        <Stack.Screen name="Users" component={Users} />
        <Stack.Screen name="Searchers" component={Searchers} />
        <Stack.Screen name="Finders" component={Finders} />
        <Stack.Screen name="UserDetails" component={UserDetails} />
        <Stack.Screen name="FinderDetails" component={FinderDetails} />
        <Stack.Screen name="SendNotifications" component={SendNotifications} />
        <Stack.Screen name="Categories" component={Categories} />
        <Stack.Screen name="EditCategory" component={EditCategory} />
        <Stack.Screen name="EditCGV" component={EditCGV} />
        <Stack.Screen name="EditMentions" component={EditMentions} />
        <Stack.Screen name="EditHowItsWork" component={EditHowItsWork} />
        <Stack.Screen
          name="ShowBugs"
          component={ShowBugs}
          options={{ headerTitle: "" }}
        />
        <Stack.Screen
          name="ShowComments"
          component={ShowComments}
          options={{ headerTitle: "" }}
        />
      </Stack.Navigator>
    );
  };

  return (
    <NavigationContainer>
      <Tab.Navigator
        screenOptions={{
          tabBarActiveTintColor: COLORS.primary,
          headerShown: false,
          tabBarShowLabel: true,
          tabBarLabelStyle: {
            fontSize: 12,
            fontFamily: "Inter_300Light",
          },
        }}
      >
        <Tab.Screen
          name="HomeTab"
          component={HomeStack}
          options={{
            title: "Accueil",
            tabBarIcon: ({ focused }) =>
              focused ? (
                <Ionicons
                  color={COLORS.primary}
                  name="home"
                  size={NAV_ICON_DEFAULT_SIZE}
                />
              ) : (
                <Ionicons
                  color={"#2d3436"}
                  name="home-outline"
                  size={NAV_ICON_DEFAULT_SIZE}
                />
              ),
          }}
        />

        <Tab.Screen
          name="SearchUserTab"
          component={SearchUserStack}
          options={{
            // headerShown:true,
            title: "Rech. utilisateur",
            tabBarIcon: ({ focused }) =>
              focused ? (
                <Ionicons
                  color={COLORS.primary}
                  name="search"
                  size={NAV_ICON_DEFAULT_SIZE}
                />
              ) : (
                <Ionicons
                  color={"#2d3436"}
                  name="search-outline"
                  size={NAV_ICON_DEFAULT_SIZE}
                />
              ),
          }}
        />

        <Tab.Screen
          name="SearchPlaqueTab"
          component={SearchStack}
          options={{
            // headerShown:true,
            title: "Rech. plaque",
            tabBarIcon: ({ focused }) =>
              focused ? (
                <Ionicons
                  color={COLORS.primary}
                  name="search"
                  size={NAV_ICON_DEFAULT_SIZE}
                />
              ) : (
                <Ionicons
                  color={"#2d3436"}
                  name="search-outline"
                  size={NAV_ICON_DEFAULT_SIZE}
                />
              ),
          }}
        />

        <Tab.Screen
          name="CategoriesTab"
          component={MenuStack}
          options={{
            title: "Menu",
            tabBarIcon: ({ focused }) =>
              focused ? (
                <Ionicons
                  name="apps"
                  size={NAV_ICON_DEFAULT_SIZE}
                  color={COLORS.primary}
                />
              ) : (
                <Ionicons
                  name="apps-outline"
                  size={NAV_ICON_DEFAULT_SIZE}
                  color="#2d3436"
                />
              ),
          }}
        />
      </Tab.Navigator>
    </NavigationContainer>
  );
}
