import { View, Text, SafeAreaView } from "react-native";
import React, { useEffect, useLayoutEffect, useState } from "react";
import * as Haptics from "expo-haptics";
import BackButton from "../../components/Buttons/BackButton";
import {
  DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING,
  INPUT_CLASS,
  INPUT_CLASS_BORDER_BOTTOM,
  INPUT_CLASS_STYLE_OPEN,
} from "../../styles/constants";
import PrimaryButton from "../../components/Buttons/PrimaryButton";
import { KeyboardAwareScrollView } from "react-native-keyboard-aware-scroll-view";
import { TextInput, Alert } from "react-native";
import { doc, updateDoc } from "firebase/firestore";
import { auth, db } from "../../../config/firebase";
import { formatNumber } from "../../utils/allFunctions";
import { updateProfile } from "firebase/auth";

export default function EditCategory({ navigation, route }) {
  const { item } = route.params;
  const [isLoading, setIsLoading] = useState(false);
  const [price, setPrice] = useState(item?.price);
  const [name, setName] = useState(item?.name);
  const [image, setImage] = useState(item?.image);

  useLayoutEffect(() => {
    navigation.setOptions({
      headerLeft: () => <BackButton onPress={navigation.goBack} />,
      headerTitle: "Modifier",
    });
  }, [navigation]);


  const validate = async () => {
    try {
      // Update the user document in Firestore
      await updateDoc(doc(db, "categories", auth.currentUser?.uid), {
        name: name.toLowerCase(),
        price: price,
        image: image,
      });

      Alert.alert(
        "Succès",
        "Données modifiées avec succès",

        [{ text: "Ok", onPress: () => navigation.goBack() }]
      );
    } catch (error) {
      Alert.alert("Erreur lors de la mise à jour", `${error.message}`);
    }
  };

  return (
    <SafeAreaView className="flex-1 bg-gray-100">
      <KeyboardAwareScrollView
        className="p-4"
        keyboardDismissMode="interactive"
        keyboardShouldPersistTaps="handled"
        // resetScrollToCoords={{ x: 0, y: 0 }}
        scrollEnabled
        behavior="padding"
        contentContainerStyle={{
          paddingBottom: DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING,
        }}
      >
        <View className="">
          <View className="">
            {/* flex view group for first and last name input */}
            <View className="w-full">
              <Text
                className="text-sm mb-2 ml-1"
                style={{ fontFamily: "Inter_400Regular" }}
              >
                Nom
              </Text>
              <TextInput
                style={{ fontFamily: "Inter_500Medium" }}
                className={INPUT_CLASS}
                placeholder="Nom *"
                placeholderTextColor={"gray"}
                value={name}
                onChangeText={setName}
              />
            </View>
            <View className="mt-3 w-full">
              <Text
                className="text-sm mb-2 ml-1"
                style={{ fontFamily: "Inter_400Regular" }}
              >
                Prix
              </Text>
              <TextInput
              keyboardType="numbers-and-punctuation"
                style={{ fontFamily: "Inter_500Medium" }}
                className={INPUT_CLASS}
                placeholder="Prix *"
                placeholderTextColor={"gray"}
                value={price}
                onChangeText={setPrice}
              />
            </View>
           

          
          </View>
          {/* validate button */}
          <View className="flex-1 mt-10 w-full">
            <View className="w-full">
              <PrimaryButton
                text={"Valider les modifs"}
                isLoading={isLoading}
                onPress={validate}
              />
            </View>
          </View>
        </View>
      </KeyboardAwareScrollView>
    </SafeAreaView>
  );
}
