import { View, Text, SafeAreaView, ScrollView } from "react-native";
import React, { useEffect, useLayoutEffect, useState } from "react";
import { Ionicons } from "@expo/vector-icons";
import * as Haptics from "expo-haptics";
import BackButton from "../components/Buttons/BackButton";
import {
  DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING,
  INPUT_CLASS,
  INPUT_CLASS_BORDER_BOTTOM,
  TEXT_AREA_CLASS,
} from "../styles/constants";
import PageSubTitle from "../components/Titles/PageSubTitle";
import PrimaryButton from "../components/Buttons/PrimaryButton";
import { KeyboardAwareScrollView } from "react-native-keyboard-aware-scroll-view";
import { TextInput } from "react-native";
import { addDoc, collection, doc, getDoc, updateDoc } from "firebase/firestore";
import { auth, db } from "../../config/firebase";
import { Alert } from "react-native";
import moment from "moment";

export default function EditMentions({ navigation, route }) {
  const [isLoading, setIsLoading] = useState(true);
  const [text, setText] = useState("");

  useLayoutEffect(() => {
    navigation.setOptions({
      headerLeft: () => <BackButton onPress={navigation.goBack} />,
      headerTitle: "",
      headerTitle: "Modifier Mentions",
    });
  }, [navigation]);

  useEffect(() => {
    getData();
  }, []);

  const validateValidate = () => {
    Alert.alert(
      "Enregistrer les modifications",
      "Êtes vous sûr de vouloir continuer?",
      [
        { text: "Enregistrer", onPress: () => validate() },
        {
          text: "Retour",
          style: "cancel",
        },
      ],
      {
        cancelable: true,
      }
    );
  };

  const getData = async () => {
    try {
      const docRef = doc(db, "CGV", "CGV");
      const res = await getDoc(docRef);
      setText(res.data().mentions);
    } catch (e) {
      Alert.alert("Erreur", `${e}`);
    } finally {
      setIsLoading(false);
    }
  };

  const validate = async () => {
    setIsLoading(true);

    try {
      const docRef = doc(db, "CGV", "CGV");
      await updateDoc(docRef, {
        mentions: text,
      });
      navigation.goBack();
    } catch (e) {
      Alert.alert("Erreur de modification: ", `${e}`);
    } finally {
      setIsLoading(false);
    }
  };

  return (
    <SafeAreaView className="flex-1 bg-white">
      <KeyboardAwareScrollView
        className="p-4"
        keyboardDismissMode="interactive"
        keyboardShouldPersistTaps="handled"
        // resetScrollToCoords={{ x: 0, y: 0 }}
        scrollEnabled
        behavior="padding"
        contentContainerStyle={{
          paddingBottom: DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING,
        }}
      >
        {/* <View className="">
          <PageSubTitle title={"Laisser un avis"} />
        </View> */}

        <View className="mt-5"></View>

        <View className="my-2">
          <TextInput
            style={{ fontFamily: "Inter_400Regular" }}
            multiline
            textAlignVertical="top"
            className={
              "bg-gray-100 border border-gray-300 w-10/12 rounded px-3 py-2 h-[60vh] text-base"
            }
            placeholder=""
            placeholderTextColor={"gray"}
            value={text}
            onChangeText={(val) => {
              setText(val);
            }}
          />
        </View>
        {/* validate button */}
        <View className="flex-1 mt-10 w-full">
          <PrimaryButton
            text={"Enregistrer les modifications"}
            isLoading={isLoading}
            onPress={validateValidate}
          />
        </View>
      </KeyboardAwareScrollView>
    </SafeAreaView>
  );
}
