import {
  View,
  Text,
  Image,
  SafeAreaView,
  TouchableOpacity,
  Alert,
  StatusBar,
  Platform,
  Pressable,
} from "react-native";
import React, {
  useCallback,
  useEffect,
  useLayoutEffect,
  useState,
} from "react";
import {
  collection,
  doc,
  getDocs,
  query,
  setDoc,
  where,
} from "firebase/firestore";
import { auth, db } from "../../config/firebase";
import { Dimensions } from "react-native";
import { LineChart, ProgressChart } from "react-native-chart-kit";
import PageLoader from "../components/Loaders/PageLoader";
import { useSafeAreaInsets } from "react-native-safe-area-context";
import { KeyboardAwareScrollView } from "react-native-keyboard-aware-scroll-view";
import { DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING } from "../styles/constants";
import { COLORS } from "../styles/colors";
import { Ionicons } from "@expo/vector-icons";
import AsyncStorage from "@react-native-async-storage/async-storage";
import { signOut } from "firebase/auth";
import PageTitle from "../components/Titles/PageTitle";
import { useFocusEffect } from "@react-navigation/native";
import * as Device from "expo-device";
import * as Notifications from "expo-notifications";
import Constants from "expo-constants";

import * as Constantss from "expo-constants";

Notifications.setNotificationHandler({
  handleNotification: async () => ({
    shouldShowAlert: true,
    shouldPlaySound: false,
    shouldSetBadge: false,
  }),
});

export default function Menu({ navigation }) {
  const List = ({ icon, text, onPress }) => (
    <Pressable
      onPress={onPress}
      className="w-[50%] items-center justify-center border border-gray-100 p-3"
    >
      <Ionicons name={`${icon}`} size={40} color={"#16a085"} />
      <Text
        className="text-base text-center text-gray-700 mb-2"
        style={{ fontFamily: "Inter_400Regular" }}
      >
        {text}
      </Text>
    </Pressable>
  );

  return (
    <SafeAreaView className="flex-1 bg-gray-200">
      <KeyboardAwareScrollView
        className="py-3"
        keyboardDismissMode="interactive"
        keyboardShouldPersistTaps="handled"
        scrollEnabled
        behavior="padding"
        contentContainerStyle={{
          paddingBottom: DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING,
          paddingHorizontal: 10,
        }}
      >
        <View className="bg-white mt-1 rounded-md">
          <View className="flex-row flex-wrap items-center">
            <List
              onPress={() => navigation.navigate("Users")}
              number={""}
              icon={"person-outline"}
              text="Utilisateurs"
            />
            <List
              onPress={() => navigation.navigate("Searchers")}
              number={""}
              icon={"person-outline"}
              text="Chercheurs"
            />
            <List
              onPress={() => navigation.navigate("Finders")}
              number={""}
              icon={"person-outline"}
              text="Trouveurs"
            />
            <List
              onPress={() => navigation.navigate("Searchs")}
              number={""}
              icon={"search-outline"}
              text="Véh. recherchés"
            />
            <List
              onPress={() => navigation.navigate("FindedSearchs")}
              number={""}
              icon={"checkmark"}
              text="Matchs"
            />
            <List
              onPress={() => navigation.navigate("Payments")}
              number={""}
              icon={"logo-euro"}
              text="Paiements"
            />
            {/* <List onPress={()=>navigation.navigate("SendNotifications")} number={""} icon={"mail-outline"} text="Notifications" /> */}
            <List
              onPress={() => navigation.navigate("Categories")}
              number={""}
              icon={"apps-outline"}
              text="Categories"
            />
            <List
              onPress={() => navigation.navigate("EditCGV")}
              number={""}
              icon={"newspaper-outline"}
              text="Modifier CGV"
            />
            <List
              onPress={() => navigation.navigate("EditHowItsWork")}
              number={""}
              icon={"newspaper-outline"}
              text="Modifier CCM"
            />
            <List
              onPress={() => navigation.navigate("EditMentions")}
              number={""}
              icon={"newspaper-outline"}
              text="Modifier MENTIONS"
            />
             <List
              onPress={() => navigation.navigate("ShowBugs")}
              number={""}
              icon={"newspaper-outline"}
              text="Liste des bugs"
            />
              <List
              onPress={() => navigation.navigate("ShowComments")}
              number={""}
              icon={"newspaper-outline"}
              text="Liste des commentaires"
            />
          </View>
        </View>
      </KeyboardAwareScrollView>
    </SafeAreaView>
  );
}
