import { View, Text, TextInput, TouchableOpacity } from "react-native";
import React, { useEffect, useLayoutEffect, useState } from "react";
import { auth, db } from "../../../config/firebase";
import {
  addDoc,
  collection,
  doc,
  getDoc,
  getDocs,
  limit,
  onSnapshot,
  orderBy,
  query,
  startAfter,
  updateDoc,
  where,
} from "firebase/firestore";
import { Pressable } from "react-native";
import { SafeAreaView } from "react-native";
import {
  DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING,
  INPUT_CLASS_BORDER_BOTTOM,
  LISTING_LIMIT,
} from "../../styles/constants";
import PageLoader from "../../components/Loaders/PageLoader";
import { FlashList } from "@shopify/flash-list";
import ListIcons from "../../components/ListIcons";
import { Image } from "react-native";
import moment from "moment";

export default function PaymentTransfered({ navigation }) {
  const [data, setData] = useState([]);
  const [isLoading, setIsLoading] = useState(true);
  const [textt, setTextt] = useState("");

  useEffect(() => {
    getData();
  }, []);

  useLayoutEffect(() => {
    navigation.setOptions({
      headerTitle: "",
    });
  }, [navigation]);

  async function getData() {
    try {
      let q = query(
        collection(db, "searchs"),
        where("paymentStatus", "==", "paid"),
        orderBy("paiedAt", "desc")
      );

      const querySnapshot = await getDocs(q);
      const dataArr = [];

      for (const res of querySnapshot.docs) {
        const finderData = res.data();
        const userRef = doc(db, "users", finderData.finderId);
        const userDoc = await getDoc(userRef);
        const userData = userDoc.exists() ? userDoc.data() : {};

        dataArr.push({
          id: res.id,
          ...finderData,
          user: userData,
        });
      }

      setData(dataArr);
    } catch (error) {
      console.log(error);
    } finally {
      setIsLoading(false);
    }
  }

  const updatePaymentFinder = async (itemId) => {
    try {
      const docRef = doc(db, "searchs", itemId);
      await updateDoc(docRef, {
        finderPrice: "7", // Assurez-vous que textt est défini
        finderPaymentStatus: "paid",
        finderPaiedAt: moment().toISOString(), // Correction du format de date
      });
      console.log("Document successfully updated!");
      getData(); // Rafraîchit les données après la mise à jour
    } catch (err) {
      console.log("Error updating document: ", err);
    }
  };

  const Card = ({ item }) => (
    <Pressable
      className={
        item.finderPaymentStatus == "paid"
          ? "p-3 bg-green-600 border border-gray-200 mb-2 flex-row items-center justify-between"
          : "p-3 bg-blue-500 border border-gray-200 mb-2 flex-row items-center justify-between"
      }
    >
      <View className="flex-row items-center">
        <View>
          <View className="flex-row items-center">
            <Text
              className="text-base text-white capitalize"
              style={{ fontFamily: "Inter_400Regular" }}
            >
              Catégorie : {item.type} ({item.price} €)
            </Text>
          </View>
          <View className="flex-row items-center">
            <Text
              className="text-base text-white uppercase"
              style={{ fontFamily: "Inter_400Regular" }}
            >
              Trouveur : {item.user.firstName + item.user.lastName}
            </Text>
          </View>
          <View className="flex-row items-center">
            <Text
              className="text-base text-white uppercase"
              style={{ fontFamily: "Inter_400Regular" }}
            >
              Plaque : {item.plate}
            </Text>
          </View>
          {item.finderPaymentStatus == "paid" && (
            <View className="flex-row items-center">
              <Text
                className="text-base text-white capitalize"
                style={{ fontFamily: "Inter_400Regular" }}
              >
                Montant payé : {item.finderPrice + " €"}
              </Text>
            </View>
          )}
          {item.finderPaymentStatus == "paid" && (
            <View className="flex-row items-center">
              <Text
                className="text-base text-white capitalize"
                style={{ fontFamily: "Inter_400Regular" }}
              >
                Heure : {moment(item?.finderPaiedAt).format("hh:mm a")}
              </Text>
            </View>
          )}
          {item.finderPaymentStatus == "paid" && (
            <View className="flex-row items-center">
              <Text
                className="text-base text-white capitalize"
                style={{ fontFamily: "Inter_400Regular" }}
              >
                Date : {moment(item?.finderPaiedAt).format("DD/MM/YYYY")}
              </Text>
            </View>
          )}
          {item.finderPaymentStatus !== "paid" && (
            <View className="mt-4 flex-row justify-end items-center w-full">
             
              <TouchableOpacity
                onPress={() => updatePaymentFinder(item.id)}
                className="rounded-sm bg-green-500 p-2"
              >
                <Text
                  className="text-xs text-white uppercase"
                  style={{ fontFamily: "Inter_500Medium" }}
                >
                  Trouveur payé
                </Text>
              </TouchableOpacity>
            </View>
           )} 
        </View>
      </View>
    </Pressable>
  );

  if (isLoading) {
    return <PageLoader />;
  }

  if (!data.length) {
    <View className="flex-1 bg-white items-center justify-center px-[10%] -mt-[50%]">
      <Image
        source={require("../../../assets/img/cardd.png")}
        resizeMode="contain"
        className="w-24 h-24"
      />
      <Text
        className="text-base text-center text-black mt-10 mb-2"
        style={{ fontFamily: "Inter_500Medium" }}
      >
        Rien à afficher
      </Text>
      <Text className="text-sm text-center text-gray-700">
        Vos paiements à envoyer s'afficheront tous ici.
      </Text>
    </View>;
  }

  return (
    <SafeAreaView className="flex-1 bg-gray-100">
      <FlashList
        estimatedItemSize={50}
        className="p-4"
        contentContainerStyle={{
          paddingBottom: DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING,
        }}
        keyExtractor={(item) => item.id}
        data={data}
        renderItem={({ item }) => <Card item={item} />}
      />
    </SafeAreaView>
  );
}
