import {
  View,
  Text,
  Image,
  SafeAreaView,
  TouchableOpacity,
  Alert,
  StatusBar,
  Platform,
  TextInput,
  Pressable,
} from "react-native";
import React, {
  useCallback,
  useEffect,
  useLayoutEffect,
  useState,
} from "react";
import {
  collection,
  doc,
  getDocs,
  query,
  setDoc,
  where,
} from "firebase/firestore";
import { auth, db } from "../../config/firebase";
import { Dimensions } from "react-native";
import { LineChart, ProgressChart } from "react-native-chart-kit";
import PageLoader from "../components/Loaders/PageLoader";
import { useSafeAreaInsets } from "react-native-safe-area-context";
import { KeyboardAwareScrollView } from "react-native-keyboard-aware-scroll-view";
import {
  DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING,
  INPUT_CLASS_BORDER_BOTTOM,
  INPUT_CLASS_BORDER_BOTTOM_BG_WHITE,
} from "../styles/constants";
import { COLORS } from "../styles/colors";
import { Ionicons } from "@expo/vector-icons";
import AsyncStorage from "@react-native-async-storage/async-storage";
import { signOut } from "firebase/auth";
import PageTitle from "../components/Titles/PageTitle";
import { useFocusEffect } from "@react-navigation/native";
import * as Device from "expo-device";
import * as Notifications from "expo-notifications";
import Constants from "expo-constants";

import * as Constantss from "expo-constants";
import PrimaryButton from "../components/Buttons/PrimaryButton";
import { FlashList } from "@shopify/flash-list";
import moment from "moment";

export default function SearchUser({ navigation }) {
  const [search, setSearch] = useState("");
  const [data, setData] = useState([]);
  const [isLoading, setIsLoading] = useState(false);
  const [hasSearched, setHasSearched] = useState(false);

  useEffect(() => {}, []);
  useLayoutEffect(() => {
    navigation.setOptions({
      headerTitle: "Rechercher un utilisateur",
    });
  }, [navigation]);

  async function validate() {
    setIsLoading(true);
    if (!search) {
      Alert.alert("Veuillez rentrer une adresse e-mail correcte");
      setIsLoading(false);
      return;
    }

    try {
      const postsCollection = collection(db, "users");
      const q = query(
        postsCollection,
        where("email", "==", search.replace(/\s+/g, "").toLowerCase())
      );
      const querySnapshot = await getDocs(q);

      const results = [];
      querySnapshot.forEach((doc) => {
        results.push({ id: doc.id, ...doc.data() });
      });

      setData(results);
      setHasSearched(true);
    } catch (error) {
      setData([]);
      setHasSearched(true);
      Alert.alert(`Erreur: ${error}`);
    } finally {
      setIsLoading(false);
    }
  }

  const Card = ({ item }) => (
    <Pressable
      className="p-3 bg-white border border-gray-200 mt-2 rounded-md flex-row items-center justify-between"
      onPress={() => navigation.navigate("UserDetails", { item })}
    >
      <View className="flex-1 flex-row items-center">
        <View>
          <View className="flex-row items-center">
            <Text
              className="text-base text-gray-700"
              style={{ fontFamily: "Inter_400Regular" }}
            >
              {item.firstName + " "}
              <Text
                className="text-base text-gray-700"
                style={{ fontFamily: "Inter_500Medium" }}
              >
                {item.lastName}
              </Text>
            </Text>
          </View>
          <View className="mt-1 flex-row items-center">
            <Text
              className="text-xs text-blue-600"
              style={{ fontFamily: "Inter_400Regular" }}
            >
              {moment(item?.createdAt).format("DD/MM/YYYY")} ·{" "}
              {item.isActive == undefined
                ? "Actif"
                : item.isActive
                ? "Actif"
                : "Inactif"}
            </Text>
          </View>
        </View>
      </View>
    
    </Pressable>
  );

  if (isLoading) {
    return <PageLoader />;
  }

  return (
    <SafeAreaView className="flex-1 bg-gray-200">
      {!data.length && !hasSearched ? (
        <KeyboardAwareScrollView
          className="p-4"
          keyboardDismissMode="interactive"
          keyboardShouldPersistTaps="handled"
          scrollEnabled={false}
          behavior="padding"
          contentContainerStyle={{
            paddingBottom: DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING,
          }}
        >
          <View className="">
            <TextInput
              autoCorrect={false}
              autoCapitalize="none"
              style={{ fontFamily: "Inter_500Medium" }}
              className={INPUT_CLASS_BORDER_BOTTOM_BG_WHITE}
              placeholder="Rentrez une adresse e-mail"
              placeholderTextColor={"gray"}
              value={search}
              keyboardType="email-address"
              onChangeText={(val) => {
                setSearch(val.toLowerCase());
              }}
            />
          </View>
          <View className="mt-5 w-full bg-white flex-1">
            <PrimaryButton
              text={"Rechercher"}
              isLoading={isLoading}
              onPress={validate}
            />
          </View>
        </KeyboardAwareScrollView>
      ) : !data.length && hasSearched ? (
        <View className="flex-1 bg-white items-center justify-center px-[10%] -mt-[50%]">
          <Image
            source={require("../../assets/img/x.png")}
            resizeMode="contain"
            className="w-24 h-24"
          />
          <Text
            className="text-base text-center text-black mt-10 mb-2"
            style={{ fontFamily: "Inter_500Medium" }}
          >
            Rien à afficher
          </Text>
          <Text className="text-sm text-center text-gray-700">
            Aucun utilisateur ne correspond à {search}
          </Text>
          <View className="w-full bg-white py-4">
            <PrimaryButton
              text={"Rechercher à nouveau"}
              onPress={() => {
                setSearch("");
                setData([]);
                setHasSearched(false); // Réinitialiser l'état de la recherche
              }}
            />
          </View>
        </View>
      ) : (
        <FlashList
          ListHeaderComponent={() => (
            <View className="w-full bg-white p-4">
              <PrimaryButton
                text={"Rechercher à nouveau"}
                onPress={() => {
                  setSearch("");
                  setData([]);
                  setHasSearched(false); // Réinitialiser l'état de la recherche
                }}
              />
            </View>
          )}
          estimatedItemSize={50}
          className="p-4"
          contentContainerStyle={{
            paddingBottom: DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING,
          }}
          keyExtractor={(item) => item.id}
          data={data}
          renderItem={({ item }) => <Card item={item} />}
        />
      )}
    </SafeAreaView>
  );
}
