import React from "react";
import { Pressable, Text, View, TouchableOpacity } from "react-native";
import { Ionicons } from "@expo/vector-icons";
import Animated, { FadeIn, FadeOut } from "react-native-reanimated";

export default function SettingsCard({
  color,
  title,
  subTitle,
  red,
  green,
  iconName,
  onPress,
}) {
  return (
    <TouchableOpacity
      entering={FadeIn}
      exiting={FadeOut}
      onPress={onPress}
      activeOpacity={0.5}
      className="my-1 p-2  flex-row rounded-xl items-center w-full border-b border-gray-200"
    >
      {/* left icon */}
      <View
        className={`mr-5 ${
          green ? "bg-green-100" : red ? "bg-red-100" : "bg-gray-100"
        } w-9 h-9 rounded-full items-center justify-center`}
      >
        <Ionicons
          name={iconName}
          size={18}
          color={green ? "green" : color ? color : red ? "red" : "black"}
        />
      </View>
      {/* title */}
      <View className="flex-1">
        <Text
          className="text-base text-gray-100"
          style={{
            fontFamily: "Inter_400Regular",
            color: green ? "green" : red ? "red" : "#33333",
          }}
        >
          {title}
        </Text>
        {subTitle && (
          <Text
            className="text-sm text-gray-700"
            style={{
              fontFamily: "Inter_400Regular",
            }}
          >
            {subTitle}
          </Text>
        )}
      </View>
      {/* right icon */}
      <View className="w-1/6 items-end">
        <Ionicons
          name="chevron-forward-outline"
          size={20}
          color={green ? "green" : red ? "red" : "black"}
        />
      </View>
    </TouchableOpacity>
  );
}
