import { useLayoutEffect } from "react";
import { useTranslation } from "react-i18next";
import {
  Alert,
  Image,
  SafeAreaView,
  Text,
  TouchableOpacity,
  View,
} from "react-native";
import BackButton from "../components/Buttons/BackButton";
import { KeyboardAwareScrollView } from "react-native-keyboard-aware-scroll-view";
import { DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING } from "../styles/constants";
import { Badge } from "react-native-elements";

export default function ChangeLanguage({ navigation }) {
  const { t, i18n } = useTranslation();

  useLayoutEffect(() => {
    navigation.setOptions({
      headerLeft: () => <BackButton onPress={navigation.goBack} />,
      headerTitle: t('change_language.header_title'), // Use translation here
    });
  }, [navigation, t]);

  return (
    <SafeAreaView className="flex-1 bg-white">
      <KeyboardAwareScrollView
        className="p-4"
        keyboardDismissMode="interactive"
        keyboardShouldPersistTaps="handled"
        scrollEnabled
        behavior="padding"
        contentContainerStyle={{
          paddingBottom: DEFAULT_FLATLIST_SCROLLVIEW_BOTTOM_PADDING,
        }}
      >
        <View>
          <TouchableOpacity
            className="flex-row items-center pb-3"
            onPress={() => {
              i18n.changeLanguage("fr");
              Alert.alert(t("change_language.language_changed")); // Use translation here
              navigation.goBack();
            }}
          >
            <Image
              source={require("../../assets/img/fr.png")}
              className="mr-4 rounded-full w-10 h-10 z-20"
            />
            <Text
              style={{ fontFamily: "Inter_500Medium" }}
              className="text-lg mr-2"
            >
              {t("change_language.french")} {/* Use translation here */}
            </Text>
            {i18n?.language === "fr" && (
              <Badge status="success" />
            )}
          </TouchableOpacity>
          <TouchableOpacity
            className="flex-row items-center py-3 border-y border-gray-200"
            onPress={() => {
              i18n.changeLanguage("en");
              Alert.alert(t("change_language.language_changed")); // Use translation here
              navigation.goBack();
            }}
          >
            <Image
              source={require("../../assets/img/en.png")}
              className="mr-4 rounded-full w-10 h-10 z-20"
            />
            <Text
              style={{ fontFamily: "Inter_500Medium" }}
              className="text-lg mr-2"
            >
              {t("change_language.english")} {/* Use translation here */}
            </Text>
            {i18n?.language === "en" && (
              <Badge status="success" />
            )}
          </TouchableOpacity>
        </View>
      </KeyboardAwareScrollView>
    </SafeAreaView>
  );
}
