import {
  View,
  Text,
  StyleSheet,
  TextInput,
  TouchableOpacity,
} from "react-native";
import React, { useLayoutEffect, useState } from "react";
import { updateProfile } from "firebase/auth";
import { Ionicons } from "@expo/vector-icons";
import * as Haptics from "expo-haptics";
import { auth, db } from "../../../config/firebase";
import { KeyboardAwareScrollView } from "react-native-keyboard-aware-scroll-view";
import { Keyboard } from "react-native";
import { doc, setDoc, updateDoc } from "firebase/firestore";
import moment from "moment";
import BackButton from "../../components/Buttons/BackButton";
import { BUTTON_CLASS, INPUT_CLASS } from "../../styles/constants";

export default function AddInfo({ navigation }) {
  const [firstName, setFirstName] = useState("");
  const [lastName, setLastName] = useState("");
  const [isLoading, setIsLoading] = useState(false);

  useLayoutEffect(() => {
    navigation.setOptions({
      headerLeft: () => <BackButton onPress={navigation.goBack} />,
      headerTitle: "Mettre à jour profil",
    });
  });

  const update = async () => {
    await updateProfile(auth.currentUser, {
      displayName: firstName + " " + lastName,
    });
    const myRef = doc(db, "users", auth.currentUser.uid);
    setDoc(
      myRef,
      {
        firstName: firstName,
        lastName: lastName,
      },
      { merge: true }
    );

    
    navigation.popToTop();
  };

  return (
    <KeyboardAwareScrollView
      keyboardDismissMode="interactive"
      keyboardShouldPersistTaps="handled"
      resetScrollToCoords={{ x: 0, y: 0 }}
      scrollEnabled
      contentContainerStyle={{ flex: 1, backgroundColor: "white" }}
    >
      <View
        style={{ ...StyleSheet.absoluteFill }}
        className="flex-1 flex-col justify-between"
      >
        <View className="flex-1 px-5 py-5">
          <View>
            <Text
              className="text-sm text-black mb-3"
              style={{ fontFamily:"Inter_700Bold" }}
            >
              Nom
            </Text>
            <TextInput
              className={INPUT_CLASS}
              placeholder="Votre nom"
              value={lastName}
              onChangeText={(val) => {
                setLastName(val);
              }}
            />
          </View>
          <View className="mt-8">
            <Text
              className="text-sm text-black mb-3"
              style={{ fontFamily:"Inter_700Bold" }}
            >
              Prénom
            </Text>
            <TextInput
              className={INPUT_CLASS}
              placeholder="Votre prénom"
              value={firstName}
              onChangeText={(val) => {
                setFirstName(val);
              }}
            />
          </View>

          <View className="mt-14">
            <TouchableOpacity
              className={BUTTON_CLASS}
              disabled={
                isLoading || lastName.length <= 3 || firstName.length <= 3
                  ? true
                  : false
              }
              onPress={update}
              style={{
                opacity:
                  isLoading || lastName.length <= 3 || firstName.length <= 3
                    ? 0.5
                    : 1,
              }}
            >
              <Text
                className="text-sm text-white"
                style={{ fontFamily:"Inter_700Bold" }}
              >
                Mettre à jour
              </Text>
            </TouchableOpacity>
          </View>
        </View>
      </View>
    </KeyboardAwareScrollView>
  );
}
