import {
  View,
  Text,
  TouchableOpacity
} from "react-native";
import React, { useLayoutEffect, useState } from "react";
import * as Haptics from "expo-haptics";
import { auth, db, storage } from "../../../config/firebase";
import { KeyboardAwareScrollView } from "react-native-keyboard-aware-scroll-view";
import { doc, setDoc } from "firebase/firestore";
import { FontAwesome, } from "@expo/vector-icons";
import BackButton from "../../components/Buttons/BackButton";
import { Image } from "react-native";
import * as ImagePicker from "expo-image-picker";
import { SafeAreaView } from "react-native";
import {
  getDownloadURL,
  ref,
  uploadBytesResumable,
} from "firebase/storage";

export default function CardIdentity({ navigation, route }) {
  const [recto, setRecto] = useState(null);
  const [verso, setVerso] = useState(null);
  const [isLoading, setIsLoading] = useState(false);

  const userInfo = route.params.userInfo;

  useLayoutEffect(() => {
    navigation.setOptions({
      headerLeft: () => <BackButton onPress={navigation.goBack} />,
      headerTitle: "Ma pièce d'identité",
      headerRight: () => (
        <TouchableOpacity
          disabled={recto == null || verso == null || isLoading ? true : false}
          onPress={update}
          style={{
            opacity: recto == null || verso == null || isLoading ? 0.6 : 1,
          }}
        >
          <Text
            style={{ fontFamily:"Inter_700Bold" }}
            className="text-center text-blue-500 text-sm"
          >
            Enregistrer
          </Text>
        </TouchableOpacity>
      ),
    });
  });

  const pickImage = async (data) => {
    const { status } = await ImagePicker.requestMediaLibraryPermissionsAsync();
    if (status !== "granted") {
      return;
    }

    const result = await ImagePicker.launchImageLibraryAsync({
      mediaTypes: ImagePicker.MediaTypeOptions.Images,
      allowsEditing: true,
      aspect: [4, 3],
      quality: 1,
    });

    if (!result.canceled) {
      if (data == "recto") {
        setRecto(result.assets[0].uri);
      } else if (data == "verso") {
        setVerso(result.assets[0].uri);
      }
    }
  };

  const takePhotoWithCamera = async (data) => {
    const { status } = await ImagePicker.requestCameraPermissionsAsync();
    if (status !== "granted") {
      return;
    }
    const result = await ImagePicker.launchCameraAsync({
      allowsEditing: true,
      aspect: [4, 3],
      quality: 1,
    });
    if (!result.canceled) {
      if (data == "recto") {
        setRecto(result.assets[0].uri);
      } else if (data == "verso") {
        setVerso(result.assets[0].uri);
      }
    }
  };

  const uploadRecto = async () => {
    try {
      const response = await fetch(recto);

      const blobFile = await response.blob();
      const storageRef = ref(
        storage,
        `pieces/${auth.currentUser.uid}/` + "recto_" + Date.now()
      );

      const snapshot = await uploadBytesResumable(storageRef, blobFile);

      const imageUrl = await getDownloadURL(snapshot?.ref);
      return imageUrl;
    } catch (error) {
      console.error("Error uploading or retrieving image:", error);
    }
  };

  const uploadVerso = async () => {
    try {
      const response = await fetch(verso);

      const blobFile = await response.blob();
      const storageRef = ref(
        storage,
        `pieces/${auth.currentUser.uid}/` + "verso_" + Date.now()
      );

      const snapshot = await uploadBytesResumable(storageRef, blobFile);

      const imageUrl = await getDownloadURL(snapshot?.ref);
      return imageUrl;
    } catch (error) {
      console.error("Error uploading or retrieving image:", error);
    }
  };

  const update = async () => {
    setIsLoading(true);
    const thisRecto = await uploadRecto();
    const thisVerso = await uploadVerso();

    const myRef = doc(db, "users", auth.currentUser.uid);
    await setDoc(
      myRef,
      {
        pieceRecto: thisRecto,
        pieceVerso: thisVerso,
      },
      { merge: true }
    );
    setIsLoading(false);

    
    navigation.popToTop();
  };
  return (
    <SafeAreaView className="flex-1 bg-white">
      <KeyboardAwareScrollView
        keyboardDismissMode="interactive"
        keyboardShouldPersistTaps="handled"
        resetScrollToCoords={{ x: 0, y: 0 }}
        scrollEnabled
        contentContainerStyle={{ paddingBottom: "100%" }}
      >
        <View className="flex-col justify-between">
          <View className="px-5 py-5">
            <View className="">
              <View className="flex-col items-center justify-between">
                <Text style={{ fontFamily:"Inter_700Bold" }} className="text-base mb-3">
                  Recto
                </Text>
                <View className="h-[25vh] w-[100%] bg-gray-300 rounded-xl mb-10">
                  <Image
                    className="w-full h-full rounded-xl"
                    source={{ uri: recto ? recto : userInfo.pieceRecto }}
                    resizeMode="cover"
                  />
                  {!userInfo.pieceRecto && (
                    <View className="absolute bottom-5 right-5 flex-row items-center self-center">
                      <TouchableOpacity
                        onPress={() => pickImage("recto")}
                        className="mr-3 w-10 h-10 items-center justify-center bg-gray-500 rounded-full"
                      >
                        <FontAwesome name="download" size={20} color="white" />
                      </TouchableOpacity>
                      <TouchableOpacity
                        onPress={() => takePhotoWithCamera("recto")}
                        className="w-10 h-10 items-center justify-center bg-gray-500 rounded-full"
                      >
                        <FontAwesome name="camera" size={20} color="white" />
                      </TouchableOpacity>
                    </View>
                  )}
                </View>
                <Text style={{ fontFamily:"Inter_700Bold" }} className="text-base mb-3">
                  Verso
                </Text>
                <View className="h-[25vh] w-[100%] bg-gray-300 rounded-xl">
                  <Image
                    className="w-full h-full rounded-xl"
                    source={{ uri: verso ? verso : userInfo.pieceVerso }}
                    resizeMode="cover"
                  />
                  {!userInfo.pieceVerso && (
                    <View className="absolute bottom-5 right-5 flex-row items-center self-center">
                      <TouchableOpacity
                        onPress={() => pickImage("verso")}
                        className="mr-3 w-10 h-10 items-center justify-center bg-gray-500 rounded-full"
                      >
                        <FontAwesome name="download" size={20} color="white" />
                      </TouchableOpacity>
                      <TouchableOpacity
                        onPress={() => takePhotoWithCamera("verso")}
                        className="w-10 h-10 items-center justify-center bg-gray-500 rounded-full"
                      >
                        <FontAwesome name="camera" size={20} color="white" />
                      </TouchableOpacity>
                    </View>
                  )}
                </View>
              </View>
            </View>
          </View>
        </View>
      </KeyboardAwareScrollView>
    </SafeAreaView>
  );
}
